/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.adapter;

import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.core.BlockPos;

public class Positions {
    public static BlockPos ToBlock(Position p, int y) {
        return new BlockPos(p.x, y, p.z);
    }

    public static InclusiveSpace getInclusiveSpace(Collection<Position> doors) {
        if (doors.size() < 2) {
            throw new IllegalArgumentException("Must provide at least two different positions");
        }
        HashSet<Position> uniqueDoors = new HashSet<Position>(doors);
        if (uniqueDoors.size() < 2) {
            throw new IllegalArgumentException("Must provide at least two different positions");
        }
        Position firstDoor = doors.iterator().next();
        int minX = firstDoor.x;
        int minZ = firstDoor.z;
        int maxX = firstDoor.x;
        int maxZ = firstDoor.z;
        for (Position door : doors) {
            if (door.x < minX) {
                minX = door.x;
            } else if (door.x > maxX) {
                maxX = door.x;
            }
            if (door.z < minZ) {
                minZ = door.z;
                continue;
            }
            if (door.z <= maxZ) continue;
            maxZ = door.z;
        }
        return InclusiveSpace.from(minX, minZ).to(maxX, maxZ);
    }

    public static Position FromBlockPos(BlockPos blockPos) {
        return new Position(blockPos.m_123341_(), blockPos.m_123343_());
    }
}

