/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.core;

import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.rooms.XWall;
import ca.bradj.roomrecipes.rooms.ZWall;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Room {
    public final Position doorPos;
    private final List<InclusiveSpace> space;

    public Optional<XWall> getBackXWall() {
        if (this.doorPos.z == this.getSpace().getNorthZ()) {
            return Optional.of(this.getSpace().getSouthXWall());
        }
        if (this.doorPos.z == this.getSpace().getSouthZ()) {
            return Optional.of(this.getSpace().getNorthXWall());
        }
        return Optional.empty();
    }

    public Optional<ZWall> getBackZWall() {
        if (this.doorPos.x == this.getSpace().getWestX()) {
            return Optional.of(this.getSpace().getEastZWall());
        }
        if (this.doorPos.x == this.getSpace().getEastX()) {
            return Optional.of(this.getSpace().getWestZWall());
        }
        return Optional.empty();
    }

    public String toString() {
        return "Room{doorPos=" + this.doorPos + ", space=" + this.space + "}";
    }

    public Position getDoorPos() {
        return this.doorPos;
    }

    public Room(Position doorPos, InclusiveSpace space) {
        this(doorPos, (Collection<InclusiveSpace>)ImmutableList.of((Object)space));
    }

    public Room(Position doorPos, Collection<InclusiveSpace> spaces) {
        this.doorPos = doorPos;
        this.space = new ArrayList<InclusiveSpace>(spaces);
    }

    public InclusiveSpace getSpace() {
        return this.space.get(0);
    }

    public Collection<InclusiveSpace> getSpaces() {
        return this.space;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Room room = (Room)o;
        return Objects.equals(this.doorPos, room.doorPos) && Objects.equals(this.space, room.space);
    }

    public int hashCode() {
        return Objects.hash(this.doorPos, this.space);
    }

    public Room withSpace(InclusiveSpace chopped) {
        return new Room(this.getDoorPos(), chopped);
    }

    public Room withExtraSpace(InclusiveSpace inclusiveSpace) {
        this.space.add(inclusiveSpace);
        return this;
    }
}

