/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.core.space;

import java.util.Objects;

public class Position {
    public final int x;
    public final int z;

    public Position(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public String toString() {
        return "Position{x=" + this.x + ", z=" + this.z + "}";
    }

    public Position offset(int x, int z) {
        return new Position(this.x + x, this.z + z);
    }

    public Position WithX(int x) {
        return new Position(x, this.z);
    }

    public Position WithZ(int z) {
        return new Position(this.x, z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position doorPos = (Position)o;
        return this.x == doorPos.x && this.z == doorPos.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.z);
    }

    public String getUIString() {
        return String.format("[%d, %d]", this.x, this.z);
    }
}

