/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class InclusiveSpaces {
    public static boolean overlapOnXZPlane(InclusiveSpace space1, InclusiveSpace space2) {
        int space1MinX = space1.getWestX();
        int space1MaxX = space1.getEastX();
        int space2MinX = space2.getWestX();
        int space2MaxX = space2.getEastX();
        int space1MinZ = space1.getNorthZ();
        int space1MaxZ = space1.getSouthZ();
        int space2MinZ = space2.getNorthZ();
        int space2MaxZ = space2.getSouthZ();
        boolean overlapX = false;
        if (space1MaxX > space2MinX && space2MaxX > space1MinX) {
            overlapX = true;
        }
        boolean overlapZ = false;
        if (space1MaxZ > space2MinZ && space2MaxZ > space1MinZ) {
            overlapZ = true;
        }
        return overlapX && overlapZ;
    }

    public static double calculateArea(InclusiveSpace space) {
        Position cornerA = space.getCornerA();
        Position cornerB = space.getCornerB();
        int length = Math.abs(cornerA.x - cornerB.x) + 1;
        int width = Math.abs(cornerA.z - cornerB.z) + 1;
        return Math.max(0.0, (double)length * (double)width);
    }

    public static double calculateArea(Collection<? extends InclusiveSpace> spaces) {
        return spaces.stream().mapToDouble(InclusiveSpaces::calculateArea).sum();
    }

    public static Position getRandomEnclosedPosition(InclusiveSpace space, Function<Integer, Integer> randomInt) {
        int minX = space.getWestX() + 1;
        int maxX = space.getEastX();
        int minZ = space.getNorthZ() + 1;
        int maxZ = space.getSouthZ();
        int width = maxX - minX;
        int height = maxZ - minZ;
        return new Position(minX + randomInt.apply(width), minZ + randomInt.apply(height));
    }

    public static Collection<Position> getAllEnclosedPositions(InclusiveSpace space) {
        int minX = space.getWestX() + 1;
        int maxX = space.getEastX();
        int minZ = space.getNorthZ() + 1;
        int maxZ = space.getSouthZ();
        ImmutableList.Builder b = ImmutableList.builder();
        for (int z = minZ; z <= maxZ; ++z) {
            for (int x = minX; x <= maxX; ++x) {
                b.add((Object)new Position(x, z));
            }
        }
        return b.build();
    }

    public static Position getMidpoint(InclusiveSpace space) {
        int leftInside = space.getWestX() + 1;
        int rightInside = space.getEastX() - 1;
        int halfWidth = (rightInside - leftInside) / 2;
        int northInside = space.getNorthZ() + 1;
        int southInside = space.getSouthZ() - 1;
        int halfHeight = (southInside - northInside) / 2;
        return new Position(leftInside + halfWidth, northInside + halfHeight);
    }

    public static boolean contains(Iterable<? extends InclusiveSpace> spaces, Position pos) {
        for (InclusiveSpace inclusiveSpace : spaces) {
            if (pos.x < inclusiveSpace.getWestX() + 1 || pos.x > inclusiveSpace.getEastX() || pos.z < inclusiveSpace.getNorthZ() + 1 || pos.z > inclusiveSpace.getSouthZ()) continue;
            return true;
        }
        return false;
    }

    public static boolean isWhole(InclusiveSpace space, Predicate<Position> isWallO) {
        HashMap cache = new HashMap();
        Predicate<Position> isWall = p -> cache.compute(p, (p2, r) -> r != null ? r.booleanValue() : isWallO.test((Position)p2));
        if (!InclusiveSpaces.hasNorthAndSouthWalls(space, isWall)) {
            return false;
        }
        if (!InclusiveSpaces.hasWestAndEastWalls(space, isWall)) {
            return false;
        }
        int x = space.getWestX() + 1;
        while (x < space.getEastX() - 1) {
            int xx;
            if (!InclusiveSpaces.hasZWall(space, arg_0 -> InclusiveSpaces.lambda$isWhole$2(isWall, xx = x++, arg_0))) continue;
            return false;
        }
        int z = space.getNorthZ() + 1;
        while (z < space.getSouthZ() - 1) {
            int zz;
            if (!InclusiveSpaces.hasZWall(space, arg_0 -> InclusiveSpaces.lambda$isWhole$3(isWall, zz = z++, arg_0))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasWestAndEastWalls(InclusiveSpace space, Predicate<Position> isWall) {
        return InclusiveSpaces.hasZWall(space, z -> {
            Position west = new Position(space.getWestX(), (int)z);
            Position east = new Position(space.getWestX(), (int)z);
            return isWall.test(west) && isWall.test(east);
        });
    }

    private static boolean hasZWall(InclusiveSpace space, Predicate<Integer> test) {
        for (int z = space.getNorthZ(); z < space.getSouthZ(); ++z) {
            if (test.test(z)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasXWall(InclusiveSpace space, Predicate<Integer> test) {
        for (int x = space.getWestX(); x < space.getEastX(); ++x) {
            if (test.test(x)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasNorthAndSouthWalls(InclusiveSpace space, Predicate<Position> isWall) {
        return InclusiveSpaces.hasXWall(space, x -> {
            Position north = new Position((int)x, space.getNorthZ());
            Position south = new Position((int)x, space.getSouthZ());
            return isWall.test(north) && isWall.test(south);
        });
    }

    public static boolean fullyContains(InclusiveSpace inclusiveSpace, InclusiveSpace ss) {
        if (ss.getWestX() < inclusiveSpace.getWestX()) {
            return false;
        }
        if (ss.getNorthZ() < inclusiveSpace.getNorthZ()) {
            return false;
        }
        if (ss.getEastX() > inclusiveSpace.getEastX()) {
            return false;
        }
        return ss.getSouthZ() <= inclusiveSpace.getSouthZ();
    }

    private static /* synthetic */ boolean lambda$isWhole$3(Predicate isWall, int zz, Integer x) {
        return isWall.test(new Position(x, zz));
    }

    private static /* synthetic */ boolean lambda$isWhole$2(Predicate isWall, int xx, Integer z) {
        return isWall.test(new Position(xx, z));
    }
}

