/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.RoomSplit;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.LevelRoomDetector;
import ca.bradj.roomrecipes.logic.XWalls;
import ca.bradj.roomrecipes.logic.ZWalls;
import ca.bradj.roomrecipes.logic.interfaces.WallDetector;
import ca.bradj.roomrecipes.rooms.XWall;
import ca.bradj.roomrecipes.rooms.ZWall;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class LevelRoomDetection {
    public static ImmutableMap<Position, Optional<Room>> findRooms(Collection<Position> currentDoors, int maxDistanceFromDoor, WallDetector checker) {
        return LevelRoomDetection.findRooms(currentDoors, maxDistanceFromDoor, null, checker);
    }

    public static ImmutableMap<Position, Optional<Room>> findRooms(Collection<Position> currentDoors, int maxDistanceFromDoor, @Nullable Consumer<String> fRec, WallDetector checker) {
        LevelRoomDetector d = new LevelRoomDetector(currentDoors, maxDistanceFromDoor, 1000, checker, false, fRec);
        for (int i = 0; i < 2000; ++i) {
            @Nullable ImmutableMap<Position, Optional<Room>> result = d.proceed();
            if (result == null) continue;
            return result;
        }
        throw new IllegalStateException("Room detector should self-close");
    }

    private static Optional<RoomSplit> splitRooms(Position doorPos1, Position doorPos2, InclusiveSpace space, WallDetector wd) {
        int zDoorDiff;
        int xDoorDiff;
        Position westDP = doorPos1;
        Position eastDP = doorPos2;
        if (westDP.x > eastDP.x) {
            westDP = doorPos2;
            eastDP = doorPos1;
        }
        if ((xDoorDiff = eastDP.x - westDP.x) >= (zDoorDiff = Math.max(doorPos1.z, doorPos2.z) - Math.min(doorPos1.z, doorPos2.z))) {
            ZWall westWall = space.getWestZWall();
            ZWall eastWall = space.getEastZWall();
            Optional<ZWall> middleWall = LevelRoomDetection.findMiddleZWall(westDP.x, eastDP.x, space, wd);
            if (middleWall.isPresent()) {
                return Optional.of(new RoomSplit(new Room(westDP, Positions.getInclusiveSpace((Collection<Position>)ImmutableList.of((Object)westWall.northCorner, (Object)middleWall.get().northCorner, (Object)middleWall.get().southCorner, (Object)westWall.southCorner))), new Room(eastDP, Positions.getInclusiveSpace((Collection<Position>)ImmutableList.of((Object)middleWall.get().northCorner, (Object)eastWall.northCorner, (Object)eastWall.southCorner, (Object)middleWall.get().southCorner)))));
            }
        }
        Position northDP = doorPos1;
        Position southDP = doorPos2;
        if (northDP.z > southDP.z) {
            northDP = doorPos2;
            southDP = doorPos1;
        }
        XWall northWall = space.getNorthXWall();
        XWall southWall = space.getSouthXWall();
        Optional<XWall> middleWall = LevelRoomDetection.findMiddleXWall(northDP.z, southDP.z, space, wd);
        if (middleWall.isPresent()) {
            return Optional.of(new RoomSplit(new Room(northDP, Positions.getInclusiveSpace((Collection<Position>)ImmutableList.of((Object)northWall.westCorner, (Object)northWall.eastCorner, (Object)middleWall.get().eastCorner, (Object)middleWall.get().westCorner))), new Room(southDP, Positions.getInclusiveSpace((Collection<Position>)ImmutableList.of((Object)middleWall.get().westCorner, (Object)middleWall.get().eastCorner, (Object)southWall.eastCorner, (Object)southWall.westCorner)))));
        }
        return Optional.empty();
    }

    private static Optional<ZWall> findMiddleZWall(int westX, int eastX, InclusiveSpace space, WallDetector wd) {
        for (int i = 1; i < eastX - westX; ++i) {
            ZWall middleWall = new ZWall(new Position(westX + i, space.getNorthZ()), new Position(westX + i, space.getSouthZ()));
            if (!ZWalls.isConnected(middleWall, wd)) continue;
            return Optional.of(middleWall);
        }
        return Optional.empty();
    }

    private static Optional<XWall> findMiddleXWall(int northZ, int southZ, InclusiveSpace space, WallDetector wd) {
        for (int i = 1; i < southZ - northZ; ++i) {
            XWall middleWall = new XWall(new Position(space.getWestX(), northZ + i), new Position(space.getEastX(), northZ + i));
            if (!XWalls.isConnected(middleWall, wd)) continue;
            return Optional.of(middleWall);
        }
        return Optional.empty();
    }
}

