/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.RoomRecipes;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import ca.bradj.roomrecipes.logic.RoomDetection;
import ca.bradj.roomrecipes.logic.interfaces.WallDetector;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.Nullable;

public class LevelRoomDetector {
    private final Queue<Position> doorsToProcess = new LinkedBlockingQueue<Position>();
    private final ImmutableList<Position> initialDoors;
    private final boolean enableDebugArt;
    @Nullable
    private final Consumer<String> flightRecorder;
    private Map<Position, Optional<Room>> processedRooms = new HashMap<Position, Optional<Room>>();
    private final int maxDistanceFromDoor;
    private final TriPredicate<Position, @Nullable Position, @Nullable String[][]> checker;
    private Map<Position, Integer> doorIteration = new HashMap<Position, Integer>();
    private int iteration = 0;
    private int maxIterations;
    private boolean done;
    private final Map<Position, String[][]> debugArt = new HashMap<Position, String[][]>();

    public LevelRoomDetector(Collection<Position> currentDoors, int maxDistanceFromDoor, int maxIterations, WallDetector checker, boolean enableDebugArt, @Nullable Consumer<String> flightRecorder) {
        this.doorsToProcess.addAll(currentDoors);
        this.initialDoors = ImmutableList.copyOf(currentDoors);
        this.maxDistanceFromDoor = maxDistanceFromDoor;
        this.maxIterations = maxIterations;
        HashMap cache = new HashMap();
        this.checker = (p, nextDoor, art) -> cache.compute(p, (p2, r) -> {
            if (r != null) {
                return r;
            }
            boolean b = checker.IsWall((Position)p2);
            if (enableDebugArt && nextDoor != null && art != null) {
                this.captureAsArtPixel((Position)p2, (Position)nextDoor, (String[][])art, b, "W", " ");
                this.captureSurroundingAsArtPixels(checker::IsWall, (Position)p2, (Position)nextDoor, (String[][])art, "w", "_");
            }
            return b;
        });
        this.enableDebugArt = enableDebugArt;
        if (enableDebugArt) {
            currentDoors.forEach(door -> {
                this.debugArt.put((Position)door, new String[maxDistanceFromDoor * 2 + 2][maxDistanceFromDoor * 2 + 2]);
                this.debugArt.get((Object)door)[maxDistanceFromDoor][maxDistanceFromDoor] = "D";
            });
        }
        this.flightRecorder = flightRecorder;
    }

    public boolean isDone() {
        return this.done;
    }

    public int iterationsUsed() {
        return this.iteration;
    }

    @Nullable
    public ImmutableMap<Position, Optional<Room>> proceed() {
        return this.proceed(p -> Optional.empty());
    }

    @Nullable
    public ImmutableMap<Position, Optional<Room>> proceed(Function<Position, Optional<Room>> existingRooms) {
        ++this.iteration;
        if (this.iteration > this.maxIterations) {
            RoomRecipes.LOGGER.error("Failed to detect rooms after {} iterations", (Object)this.maxIterations);
            return this.giveUp();
        }
        if (this.doorsToProcess.isEmpty()) {
            this.done = true;
            if (this.processedRooms.isEmpty()) {
                return this.giveUp();
            }
            return this.removeOverlaps(this.processedRooms);
        }
        Position nextDoor = this.doorsToProcess.remove();
        Optional<Room> existing = existingRooms.apply(nextDoor);
        if (existing.isPresent() && InclusiveSpaces.isWhole(existing.get().getSpace(), p -> this.checker.test(p, null, null))) {
            this.processedRooms.put(nextDoor, existing);
            return null;
        }
        if (this.doorIteration.getOrDefault(nextDoor, 0) > this.maxDistanceFromDoor - 2) {
            return null;
        }
        Optional<Room> roomForDoor = RoomDetection.findRoomForDoorIteration(nextDoor, this.doorIteration.getOrDefault(nextDoor, 0) + 2, this.maxDistanceFromDoor - 2, this.flightRecorder, p -> this.checker.test((Object)p, (Object)nextDoor, (Object)this.debugArt.get(nextDoor))).toOptional();
        if (roomForDoor.isEmpty()) {
            this.doorsToProcess.add(nextDoor);
            this.doorIteration.compute(nextDoor, (pos, cur) -> cur == null ? 1 : cur + 1);
            return null;
        }
        this.processedRooms.put(nextDoor, roomForDoor);
        return null;
    }

    private void captureSurroundingAsArtPixels(Predicate<Position> isWall, Position p, Position nextDoor, String[][] art, String w, String a) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                Position op = p.offset(i, j);
                boolean b2 = isWall.test(op);
                this.captureAsArtPixel(op, nextDoor, art, b2, w, a);
            }
        }
    }

    private void captureAsArtPixel(Position p, Position nextDoor, String[][] art, boolean b, String w, String a) {
        int zOffset = p.z - nextDoor.z;
        int xOffset = p.x - nextDoor.x;
        int zzz = this.maxDistanceFromDoor + zOffset;
        int xxx = this.maxDistanceFromDoor + xOffset;
        if (zzz >= art.length || xxx >= art[0].length || zzz < 0 || xxx < 0) {
            return;
        }
        try {
            String v = art[zzz][xxx];
            if (v == null || art[zzz][xxx].equals("w") || art[zzz][xxx].equals("_")) {
                art[zzz][xxx] = b ? w : a;
            }
        }
        catch (Exception e) {
            RoomRecipes.LOGGER.error("Failed to register art pixel for {} around door {}", (Object)p.getUIString(), (Object)nextDoor.getUIString());
            RoomRecipes.LOGGER.error("Exception", (Throwable)e);
        }
    }

    private ImmutableMap<Position, Optional<Room>> removeOverlaps(Map<Position, Optional<Room>> detectedRooms) {
        int attempts = 0;
        int corrections = 1;
        block0: while (corrections > 0 && attempts <= 3) {
            ++attempts;
            Stream<Optional> onlyPresent = detectedRooms.values().stream().filter(Optional::isPresent);
            List<Room> rooms = onlyPresent.map(Optional::get).toList();
            corrections = 0;
            block1: for (Room r1 : rooms) {
                if (corrections > 0) continue block0;
                for (Room r2 : rooms) {
                    InclusiveSpace chopped;
                    double a2;
                    if (r1.equals(r2)) continue;
                    if (r1.getSpace().equals(r2.getSpace())) {
                        Optional<Room> alternate = RoomDetection.findRoomForDoor(r2.getDoorPos(), this.maxDistanceFromDoor, Optional.of(r1.getSpace()), 0, this::checkWithoutArt).toOptional();
                        if (alternate.isPresent()) {
                            if (rooms.stream().anyMatch(v -> v.getSpace().equals(((Room)alternate.get()).getSpace()))) {
                                detectedRooms.put(r2.getDoorPos(), Optional.empty());
                                ++corrections;
                                continue block1;
                            }
                            RoomRecipes.LOGGER.trace("Using alternate room: " + alternate.get());
                            detectedRooms.put(r2.getDoorPos(), alternate);
                            ++corrections;
                            continue block1;
                        }
                        Optional<Room> alternate2 = RoomDetection.findRoomForDoor(r1.getDoorPos(), this.maxDistanceFromDoor, Optional.of(r2.getSpace()), 0, this::checkWithoutArt).toOptional();
                        if (alternate2.isPresent()) {
                            detectedRooms.put(r1.getDoorPos(), alternate2);
                            ++corrections;
                            RoomRecipes.LOGGER.trace("Using alternate room: " + alternate2.get());
                            continue block1;
                        }
                        detectedRooms.put(r2.getDoorPos(), Optional.empty());
                        ++corrections;
                        continue block1;
                    }
                    if (!InclusiveSpaces.overlapOnXZPlane(r1.getSpace(), r2.getSpace())) continue;
                    double a1 = InclusiveSpaces.calculateArea(r1.getSpace());
                    if (a1 > (a2 = InclusiveSpaces.calculateArea(r2.getSpace()))) {
                        RoomRecipes.LOGGER.debug("Chopping " + r2 + " off of " + r1);
                        chopped = r1.getSpace().chopOff(r2.getSpace());
                        detectedRooms.put(r1.getDoorPos(), Optional.of(r1.withSpace(chopped)));
                        ++corrections;
                        continue block1;
                    }
                    if (!(a2 > a1)) continue;
                    RoomRecipes.LOGGER.debug("Chopping " + r1 + " off of " + r2);
                    chopped = r2.getSpace().chopOff(r1.getSpace());
                    detectedRooms.put(r2.getDoorPos(), Optional.of(r2.withSpace(chopped)));
                    ++corrections;
                    continue block1;
                }
            }
        }
        return ImmutableMap.copyOf(detectedRooms);
    }

    private boolean checkWithoutArt(Position p) {
        return this.checker.test((Object)p, null, null);
    }

    private ImmutableMap<Position, Optional<Room>> giveUp() {
        ImmutableMap.Builder b = ImmutableMap.builder();
        this.initialDoors.forEach(v -> b.put(v, Optional.empty()));
        return b.build();
    }

    public ImmutableMap<Position, String> getDebugArt(boolean cropNulls) {
        if (!this.enableDebugArt) {
            RoomRecipes.LOGGER.error("Debug art was not enabled in the room detector constructor");
            return ImmutableMap.of();
        }
        ImmutableMap.Builder b = ImmutableMap.builder();
        this.debugArt.forEach((k, v) -> {
            if (cropNulls) {
                v = LevelRoomDetector.findSmallestRectangle(v);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\n");
            for (int i = 0; i < ((String[][])v).length; ++i) {
                sb.append("    {");
                for (int j = 0; j < v[i].length; ++j) {
                    String val = v[i][j];
                    sb.append("\"").append(val == null ? Character.valueOf('?') : val).append("\"");
                    if (j >= v[i].length - 1) continue;
                    sb.append(", ");
                }
                sb.append("}");
                if (i < ((String[][])v).length - 1) {
                    sb.append(",\n");
                    continue;
                }
                sb.append("\n");
            }
            sb.append("}");
            b.put(k, (Object)sb.toString());
        });
        return b.build();
    }

    public static String[][] findSmallestRectangle(String[][] array) {
        int minRow = Integer.MAX_VALUE;
        int maxRow = Integer.MIN_VALUE;
        int minCol = Integer.MAX_VALUE;
        int maxCol = Integer.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                if (array[i][j] == null) continue;
                minRow = Math.min(minRow, i);
                maxRow = Math.max(maxRow, i);
                minCol = Math.min(minCol, j);
                maxCol = Math.max(maxCol, j);
            }
        }
        int numRows = maxRow - minRow + 1;
        int numCols = maxCol - minCol + 1;
        String[][] smallestRectangle = new String[numRows][numCols];
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                smallestRectangle[i][j] = array[minRow + i][minCol + j];
            }
        }
        return smallestRectangle;
    }
}

