/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.logic;

import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.InclusiveSpace;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.Direction;
import ca.bradj.roomrecipes.logic.InclusiveSpaces;
import ca.bradj.roomrecipes.logic.RoomDetection;
import ca.bradj.roomrecipes.rooms.Wall;
import ca.bradj.roomrecipes.rooms.XWall;
import ca.bradj.roomrecipes.rooms.ZWall;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class RoomHints {
    public final XWall northWall;
    public final XWall southWall;
    public final ZWall westWall;
    public final ZWall eastWall;
    public final XWall northOpening;
    public final XWall southOpening;
    public final ZWall westOpening;
    public final ZWall eastOpening;

    public RoomHints(@Nullable XWall northWall, @Nullable XWall southWall, @Nullable ZWall westWall, @Nullable ZWall eastWall) {
        this(northWall, southWall, westWall, eastWall, null, null, null, null);
    }

    public RoomHints(@Nullable XWall northWall, @Nullable XWall southWall, @Nullable ZWall westWall, @Nullable ZWall eastWall, @Nullable XWall northOpening, @Nullable XWall southOpening, @Nullable ZWall westOpening, @Nullable ZWall eastOpening) {
        this.northWall = northWall;
        this.southWall = southWall;
        this.westWall = westWall;
        this.eastWall = eastWall;
        this.northOpening = northOpening;
        this.southOpening = southOpening;
        this.westOpening = westOpening;
        this.eastOpening = eastOpening;
    }

    public static RoomHints empty() {
        return new RoomHints(null, null, null, null);
    }

    public RoomHints withNorthWall(XWall northWall) {
        return new RoomHints(northWall, this.southWall, this.westWall, this.eastWall, this.northOpening, this.southOpening, this.westOpening, this.eastOpening);
    }

    public RoomHints withSouthWall(XWall southWall) {
        return new RoomHints(this.northWall, southWall, this.westWall, this.eastWall, this.northOpening, this.southOpening, this.westOpening, this.eastOpening);
    }

    public RoomHints withWestWall(ZWall westWall) {
        return new RoomHints(this.northWall, this.southWall, westWall, this.eastWall, this.northOpening, this.southOpening, this.westOpening, this.eastOpening);
    }

    public RoomHints withEastWall(ZWall eastWall) {
        return new RoomHints(this.northWall, this.southWall, this.westWall, eastWall, this.northOpening, this.southOpening, this.westOpening, this.eastOpening);
    }

    public boolean isRoom(RoomDetection.WallExclusion exclusion) {
        if (this.equals(RoomHints.empty())) {
            return false;
        }
        if (!(this.northOpening == null && this.northWall != null || exclusion.allowOpenNorthWall)) {
            return false;
        }
        if (!(this.southOpening == null && this.southWall != null || exclusion.allowOpenSouthWall)) {
            return false;
        }
        if (!(this.westOpening == null && this.westWall != null || exclusion.allowOpenWestWall)) {
            return false;
        }
        return this.eastOpening == null && this.eastWall != null || exclusion.allowOpenEastWall;
    }

    public Optional<Room> asRoom(Position doorPos, RoomDetection.WallExclusion exclusion) {
        Optional<InclusiveSpace> space = this.asSpace(exclusion);
        return space.map(v -> new Room(doorPos, (InclusiveSpace)v));
    }

    public Optional<InclusiveSpace> asSpace(RoomDetection.WallExclusion exclusion) {
        if (this.isRoom(exclusion)) {
            ZWall ePart;
            XWall nPart = this.northWall == null ? this.northOpening : this.northWall;
            XWall sPart = this.southWall == null ? this.southOpening : this.southWall;
            ZWall wPart = this.westWall == null ? this.westOpening : this.westWall;
            ZWall zWall = ePart = this.eastWall == null ? this.eastOpening : this.eastWall;
            if (nPart != null && sPart != null) {
                return Optional.of(InclusiveSpace.from(nPart.westCorner).to(sPart.eastCorner));
            }
            if (wPart != null && ePart != null) {
                return Optional.of(InclusiveSpace.from(wPart.northCorner).to(ePart.southCorner));
            }
        }
        return Optional.empty();
    }

    public RoomHints copy() {
        return new RoomHints(this.northWall, this.southWall, this.westWall, this.eastWall, this.northOpening, this.southOpening, this.westOpening, this.eastOpening);
    }

    public Optional<RoomHints> getOpening() {
        boolean hasOneOpening = this.hasOneOpening();
        if (hasOneOpening) {
            return Optional.empty();
        }
        if (this.northWall == null) {
            return Optional.of(new RoomHints(new XWall(this.westWall.northCorner, this.eastWall.northCorner), null, null, null));
        }
        if (this.southWall == null) {
            return Optional.of(new RoomHints(null, new XWall(this.westWall.southCorner, this.eastWall.southCorner), null, null));
        }
        if (this.westWall == null) {
            return Optional.of(new RoomHints(null, null, new ZWall(this.northWall.westCorner, this.southWall.westCorner), null));
        }
        return Optional.of(new RoomHints(null, null, null, new ZWall(this.northWall.eastCorner, this.southWall.eastCorner)));
    }

    public boolean hasOneOpening() {
        int openCount = 0;
        openCount = this.northOpening == null ? openCount : openCount + 1;
        openCount = this.southOpening == null ? openCount : openCount + 1;
        openCount = this.westOpening == null ? openCount : openCount + 1;
        openCount = this.eastOpening == null ? openCount : openCount + 1;
        boolean hasOneOpening = openCount == 1;
        return hasOneOpening;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoomHints roomHints = (RoomHints)o;
        return Objects.equals(this.northWall, roomHints.northWall) && Objects.equals(this.southWall, roomHints.southWall) && Objects.equals(this.westWall, roomHints.westWall) && Objects.equals(this.eastWall, roomHints.eastWall) && Objects.equals(this.northOpening, roomHints.northOpening) && Objects.equals(this.southOpening, roomHints.southOpening) && Objects.equals(this.westOpening, roomHints.westOpening) && Objects.equals(this.eastOpening, roomHints.eastOpening);
    }

    public int hashCode() {
        return Objects.hash(this.northWall, this.southWall, this.westWall, this.eastWall, this.northOpening, this.southOpening, this.westOpening, this.eastOpening);
    }

    public Optional<InclusiveSpace> adjoinedTo(Position doorPos, RoomHints space) {
        boolean joinS;
        boolean joinN;
        Optional<InclusiveSpace> s;
        boolean joinE;
        boolean joinW;
        if (this.northOpening != null) {
            joinW = false;
            joinE = false;
            if (space.southWall != null) {
                joinW = space.southWall.westCorner.equals(this.northOpening.westCorner);
                joinE = space.southWall.eastCorner.equals(this.northOpening.eastCorner);
            }
            if (space.southOpening != null) {
                joinW = space.southOpening.westCorner.equals(this.northOpening.westCorner);
                joinE = space.southOpening.eastCorner.equals(this.northOpening.eastCorner);
            }
            s = space.asSpace(RoomDetection.WallExclusion.allowSouthOpen());
            if (joinW && joinE && s.isPresent()) {
                return s;
            }
            if (s.isPresent() && InclusiveSpaces.calculateArea(s.get()) == 1.0) {
                return s;
            }
        }
        if (this.southOpening != null) {
            joinW = false;
            joinE = false;
            if (space.northWall != null) {
                joinW = space.northWall.westCorner.equals(this.southOpening.westCorner);
                joinE = space.northWall.eastCorner.equals(this.southOpening.eastCorner);
            }
            if (space.northOpening != null) {
                joinW = space.northOpening.westCorner.equals(this.southOpening.westCorner);
                joinE = space.northOpening.eastCorner.equals(this.southOpening.eastCorner);
            }
            s = space.asSpace(RoomDetection.WallExclusion.allowNorthOpen());
            if (joinW && joinE && s.isPresent()) {
                return s;
            }
            if (s.isPresent() && InclusiveSpaces.calculateArea(s.get()) == 1.0) {
                return s;
            }
        }
        if (this.westOpening != null) {
            joinN = false;
            joinS = false;
            if (space.eastWall != null) {
                joinN = space.eastWall.northCorner.equals(this.westOpening.northCorner);
                joinS = space.eastWall.southCorner.equals(this.westOpening.southCorner);
            }
            if (space.eastOpening != null) {
                joinN = space.eastOpening.northCorner.equals(this.westOpening.northCorner);
                joinS = space.eastOpening.southCorner.equals(this.westOpening.southCorner);
            }
            s = space.asSpace(RoomDetection.WallExclusion.allowEastOpen());
            if (joinN && joinS && s.isPresent()) {
                return s;
            }
            if (s.isPresent() && InclusiveSpaces.calculateArea(s.get()) == 1.0) {
                return s;
            }
        }
        if (this.eastOpening != null) {
            joinN = false;
            joinS = false;
            if (space.westWall != null) {
                joinN = space.westWall.northCorner.equals(this.eastOpening.northCorner);
                joinS = space.westWall.southCorner.equals(this.eastOpening.southCorner);
            }
            if (space.westOpening != null) {
                joinN = space.westOpening.northCorner.equals(this.eastOpening.northCorner);
                joinS = space.westOpening.southCorner.equals(this.eastOpening.southCorner);
            }
            s = space.asSpace(RoomDetection.WallExclusion.allowWestOpen());
            if (joinN && joinS && s.isPresent()) {
                return s;
            }
            if (s.isPresent() && InclusiveSpaces.calculateArea(s.get()) == 1.0) {
                return s;
            }
        }
        return Optional.empty();
    }

    public RoomHints withNorthOpening(XWall opening) {
        return new RoomHints(this.northWall, this.southWall, this.westWall, this.eastWall, opening, this.southOpening, this.westOpening, this.eastOpening);
    }

    public RoomHints withSouthOpening(XWall xWall) {
        return new RoomHints(this.northWall, this.southWall, this.westWall, this.eastWall, this.northOpening, xWall, this.westOpening, this.eastOpening);
    }

    public RoomHints withWestOpening(ZWall opening) {
        return new RoomHints(this.northWall, this.southWall, this.westWall, this.eastWall, this.northOpening, this.southOpening, opening, this.eastOpening);
    }

    public RoomHints withEastOpening(ZWall opening) {
        return new RoomHints(this.northWall, this.southWall, this.westWall, this.eastWall, this.northOpening, this.southOpening, this.westOpening, opening);
    }

    public boolean hasAnyOpenings() {
        return this.northOpening != null || this.southOpening != null || this.westOpening != null || this.eastOpening != null;
    }

    public Wall<?> getWall(Direction d) {
        return switch (d) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> this.northWall;
            case Direction.SOUTH -> this.southWall;
            case Direction.WEST -> this.westWall;
            case Direction.EAST -> this.eastWall;
        };
    }

    public Wall<?> getOpening(Direction d) {
        return switch (d) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> this.northOpening;
            case Direction.SOUTH -> this.southOpening;
            case Direction.WEST -> this.westOpening;
            case Direction.EAST -> this.eastOpening;
        };
    }

    public RoomHints withWall(Direction n, @Nullable Wall<?> w) {
        return switch (n) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> {
                if (w == null) {
                    yield this.withNorthWall(null);
                }
                yield this.withNorthWall(w.toXWall());
            }
            case Direction.SOUTH -> {
                if (w == null) {
                    yield this.withSouthWall(null);
                }
                yield this.withSouthWall(w.toXWall());
            }
            case Direction.WEST -> {
                if (w == null) {
                    yield this.withWestWall(null);
                }
                yield this.withWestWall(w.toZWall());
            }
            case Direction.EAST -> w == null ? this.withEastWall(null) : this.withEastWall(w.toZWall());
        };
    }

    public RoomHints withOpening(Direction n, @Nullable Wall<?> w) {
        return switch (n) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> {
                if (w == null) {
                    yield this.withNorthOpening(null);
                }
                yield this.withNorthOpening(w.toXWall());
            }
            case Direction.SOUTH -> {
                if (w == null) {
                    yield this.withSouthOpening(null);
                }
                yield this.withSouthOpening(w.toXWall());
            }
            case Direction.WEST -> {
                if (w == null) {
                    yield this.withWestOpening(null);
                }
                yield this.withWestOpening(w.toZWall());
            }
            case Direction.EAST -> w == null ? this.withEastOpening(null) : this.withEastOpening(w.toZWall());
        };
    }

    public String toShortString() {
        String inclusiveSpace = this.asSpace(RoomDetection.WallExclusion.allowAllOpen()).map(InclusiveSpace::toString).orElse(null);
        if (!this.hasAnyOpenings()) {
            return "[] " + inclusiveSpace;
        }
        if (this.northOpening != null && this.southOpening != null) {
            if (this.westOpening != null && this.eastOpening != null) {
                return "- " + inclusiveSpace;
            }
            if (this.westOpening != null) {
                return "-| " + inclusiveSpace;
            }
            if (this.eastOpening != null) {
                return "|- " + inclusiveSpace;
            }
            return "|-| " + inclusiveSpace;
        }
        if (this.northOpening != null) {
            if (this.westOpening != null && this.eastOpening != null) {
                return "_ " + inclusiveSpace;
            }
            if (this.westOpening != null) {
                return "_| " + inclusiveSpace;
            }
            if (this.eastOpening != null) {
                return "|_ " + inclusiveSpace;
            }
            return "|_| " + inclusiveSpace;
        }
        if (this.westOpening != null && this.eastOpening != null) {
            return "^ " + inclusiveSpace;
        }
        if (this.westOpening != null) {
            return "^| " + inclusiveSpace;
        }
        if (this.eastOpening != null) {
            return "|^ " + inclusiveSpace;
        }
        return "|^| " + inclusiveSpace;
    }
}

