/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.recipes;

import ca.bradj.roomrecipes.RoomRecipes;
import ca.bradj.roomrecipes.core.Room;
import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.recipes.RoomAnnouncing;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nullable;

public class ActiveRecipes<ROOM extends Room, KEY>
implements RoomAnnouncing {
    protected final Map<ROOM, KEY> activeRecipes = new HashMap<ROOM, KEY>();
    private ChangeListener<ROOM, KEY> changeListener;
    private final Stack<Position> roomsToSkipInitialAnnounce = new Stack();

    public ActiveRecipes() {
        this(Set.of());
    }

    public ActiveRecipes(Set<Map.Entry<ROOM, KEY>> recipes) {
        recipes.forEach(e -> this.activeRecipes.put((Room)e.getKey(), e.getValue()));
    }

    public void update(@Nullable ROOM oldRoom, @Nullable ROOM newRoom, @Nullable KEY recipe) {
        RoomRecipes.LOGGER.trace("Updating recipe at {} to {} at {}", oldRoom, recipe, newRoom);
        if (recipe != null) {
            if (this.activeRecipes.containsKey(oldRoom)) {
                KEY oldRecipe = this.activeRecipes.get(oldRoom);
                if (oldRecipe.equals(recipe)) {
                    if (((Room)oldRoom).equals(newRoom)) {
                        return;
                    }
                    this.activeRecipes.remove(oldRoom);
                    if (newRoom == null) {
                        this.changeListener.roomRecipeDestroyed(oldRoom, recipe);
                        return;
                    }
                    this.activeRecipes.put(newRoom, recipe);
                    this.changeListener.roomRecipeChanged(oldRoom, recipe, newRoom, recipe);
                    return;
                }
                this.activeRecipes.put(newRoom, recipe);
                this.changeListener.roomRecipeChanged(oldRoom, oldRecipe, newRoom, recipe);
                return;
            }
            this.activeRecipes.put(newRoom, recipe);
            if (newRoom != null && this.roomsToSkipInitialAnnounce.contains(((Room)newRoom).doorPos)) {
                this.roomsToSkipInitialAnnounce.remove(((Room)newRoom).doorPos);
            } else {
                this.changeListener.roomRecipeCreated(newRoom, recipe);
            }
            return;
        }
        if (this.activeRecipes.containsKey(oldRoom)) {
            KEY oldRecipeId = this.activeRecipes.remove(oldRoom);
            this.changeListener.roomRecipeDestroyed(oldRoom, oldRecipeId);
            return;
        }
        if (recipe != null) {
            RoomRecipes.LOGGER.error("An unexpected recipe was removed. This is likely a bug. [{}, {}, {}]", oldRoom, newRoom, recipe);
        }
    }

    @Override
    public void skipAnnounceOnFirstDetect(Collection<Position> roomsToSkip) {
        this.roomsToSkipInitialAnnounce.addAll(roomsToSkip);
    }

    public void addChangeListener(ChangeListener<ROOM, KEY> cl) {
        this.changeListener = cl;
    }

    public int size() {
        return this.activeRecipes.size();
    }

    public Set<Map.Entry<ROOM, KEY>> entrySet() {
        return this.activeRecipes.entrySet();
    }

    public static interface ChangeListener<ROOM, KEY> {
        public void roomRecipeCreated(ROOM var1, KEY var2);

        public void roomRecipeChanged(ROOM var1, KEY var2, ROOM var3, KEY var4);

        public void roomRecipeDestroyed(ROOM var1, KEY var2);
    }
}

