/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.recipes;

import ca.bradj.roomrecipes.RoomRecipes;
import ca.bradj.roomrecipes.core.Room;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ActiveRecipesV2<KEY> {
    protected final Map<Room, KEY> activeRecipes = new HashMap<Room, KEY>();
    private ChangeListener<KEY> changeListener;

    public ActiveRecipesV2() {
        this(Set.of());
    }

    public ActiveRecipesV2(Set<Map.Entry<Room, KEY>> recipes) {
        recipes.forEach(e -> this.activeRecipes.put((Room)e.getKey(), e.getValue()));
    }

    public void update(Room roomDoorPos, @Nullable KEY recipe) {
        RoomRecipes.LOGGER.trace("Updating recipe at " + roomDoorPos + " to " + recipe);
        if (recipe != null) {
            if (this.activeRecipes.containsKey(roomDoorPos)) {
                KEY oldRecipe = this.activeRecipes.get(roomDoorPos);
                if (oldRecipe.equals(recipe)) {
                    return;
                }
                this.activeRecipes.put(roomDoorPos, recipe);
                this.changeListener.roomRecipeChanged(roomDoorPos, oldRecipe, recipe);
                return;
            }
            this.activeRecipes.put(roomDoorPos, recipe);
            this.changeListener.roomRecipeCreated(roomDoorPos, recipe);
            return;
        }
        if (this.activeRecipes.containsKey(roomDoorPos)) {
            KEY oldRecipeId = this.activeRecipes.remove(roomDoorPos);
            this.changeListener.roomRecipeDestroyed(roomDoorPos, oldRecipeId);
            return;
        }
        if (recipe != null) {
            RoomRecipes.LOGGER.error("An unexpected recipe was removed. This is likely a bug.");
        }
    }

    public void addChangeListener(ChangeListener<KEY> cl) {
        this.changeListener = cl;
    }

    public int size() {
        return this.activeRecipes.size();
    }

    public Set<Map.Entry<Room, KEY>> entrySet() {
        return this.activeRecipes.entrySet();
    }

    public static interface ChangeListener<KEY> {
        public void roomRecipeCreated(Room var1, KEY var2);

        public void roomRecipeChanged(Room var1, KEY var2, KEY var3);

        public void roomRecipeDestroyed(Room var1, KEY var2);
    }
}

