/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.recipes;

import ca.bradj.roomrecipes.adapter.Positions;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatch;
import ca.bradj.roomrecipes.adapter.RoomRecipeMatches;
import ca.bradj.roomrecipes.logic.DoorDetection;
import ca.bradj.roomrecipes.recipes.RecipesInit;
import ca.bradj.roomrecipes.recipes.RoomRecipe;
import ca.bradj.roomrecipes.serialization.MCRoom;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class RecipeDetection {
    @Deprecated
    public static Optional<RoomRecipeMatch<MCRoom>> getActiveRecipe(Level level, MCRoom room, DoorDetection.DoorChecker doorChecker) {
        return RecipeDetection.getActiveRecipes(level, room, false).map(v -> v);
    }

    public static Optional<RoomRecipeMatches<MCRoom>> getActiveRecipes(Level level, MCRoom room, boolean getFarmRecipesOnly) {
        ImmutableMap<BlockPos, Block> blocksInSpace = RecipeDetection.getBlocksInRoom(level, room, false);
        RecipeManager recipeManager = level.m_7465_();
        ImmutableList blocksList = ImmutableList.copyOf(blocksInSpace.values());
        SimpleContainer inv = new SimpleContainer(blocksList.size());
        for (int i = 0; i < blocksList.size(); ++i) {
            ItemStack stackInSlot = new ItemStack((ItemLike)blocksList.get(i), 1);
            inv.m_6836_(i, stackInSlot);
        }
        List recipes = recipeManager.m_44013_(RecipesInit.ROOM);
        List<ResourceLocation> matchedRecipes = (recipes = Lists.reverse((List)ImmutableList.sortedCopyOf((Iterable)recipes))).stream().filter(r -> getFarmRecipesOnly ? r.isFarmRecipe() : true).filter(r -> r.m_5818_((Container)inv, level)).map(RoomRecipe::m_6423_).toList();
        if (matchedRecipes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new RoomRecipeMatches<MCRoom>(room, (ImmutableList<ResourceLocation>)ImmutableList.copyOf(matchedRecipes), blocksInSpace.entrySet()));
    }

    public static ImmutableMap<BlockPos, Block> getBlocksInRoom(Level level, MCRoom room, boolean includeWallBlocks) {
        return RecipeDetection.getBlocksInRoomV2(bp -> level.m_8055_(bp).m_60734_(), room, includeWallBlocks);
    }

    public static ImmutableMap<BlockPos, Block> getBlocksInRoomV2(Function<BlockPos, Block> level, MCRoom room, boolean includeWallBlocks) {
        BlockPos pos1 = Positions.ToBlock(room.getSpace().getCornerA(), room.yCoord);
        BlockPos pos2 = Positions.ToBlock(room.getSpace().getCornerB(), room.yCoord).m_7494_();
        ImmutableMap.Builder b = ImmutableMap.builder();
        int xMin = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int xMax = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int zMin = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int zMax = Math.max(pos1.m_123343_(), pos2.m_123343_());
        if (!includeWallBlocks) {
            ++xMin;
            --xMax;
            ++zMin;
            --zMax;
        }
        int chunkXMin = xMin >> 4;
        int chunkXMax = xMax >> 4;
        int chunkZMin = zMin >> 4;
        int chunkZMax = zMax >> 4;
        for (int chunkX = chunkXMin; chunkX <= chunkXMax; ++chunkX) {
            for (int chunkZ = chunkZMin; chunkZ <= chunkZMax; ++chunkZ) {
                int blockXMin = Math.max(xMin, chunkX << 4);
                int blockXMax = Math.min(xMax, (chunkX << 4) + 15);
                int blockZMin = Math.max(zMin, chunkZ << 4);
                int blockZMax = Math.min(zMax, (chunkZ << 4) + 15);
                for (int blockX = blockXMin; blockX <= blockXMax; ++blockX) {
                    for (int blockZ = blockZMin; blockZ <= blockZMax; ++blockZ) {
                        int yMin = Math.min(pos1.m_123342_(), pos2.m_123342_());
                        int yMax = Math.max(pos1.m_123342_(), pos2.m_123342_());
                        for (int blockY = yMin; blockY <= yMax; ++blockY) {
                            BlockPos blockPos = new BlockPos(blockX, blockY, blockZ);
                            Block block = level.apply(blockPos);
                            b.put((Object)blockPos, (Object)block);
                        }
                    }
                }
            }
        }
        return b.build();
    }
}

