/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.recipes;

import ca.bradj.roomrecipes.recipes.NoMCRomRecipe;
import ca.bradj.roomrecipes.recipes.RecipesInit;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.primitives.Ints;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class RoomRecipe
implements Recipe<Container>,
Comparable<RoomRecipe> {
    private final int recipeStrength;
    private boolean farm;
    private final ResourceLocation id;
    private final NonNullList<Ingredient> recipeItems;

    public boolean m_5598_() {
        return true;
    }

    public String toString() {
        return "RoomRecipe{id=" + this.id + ", recipeItems=" + this.recipeItems + "}";
    }

    @Deprecated(since="1.18.2-0.0.6-alpha.3")
    public RoomRecipe(ResourceLocation id, NonNullList<Ingredient> recipeItems, int recipeStrength) {
        this(id, recipeItems, recipeStrength, false);
    }

    public RoomRecipe(ResourceLocation id, NonNullList<Ingredient> recipeItems, int recipeStrength, boolean isRecipeForFarms) {
        this.id = id;
        this.recipeItems = recipeItems;
        this.recipeStrength = recipeStrength;
        this.farm = isRecipeForFarms;
    }

    public boolean m_5818_(Container inv, Level p_77569_2_) {
        ArrayList<Ingredient> found = new ArrayList<Ingredient>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack item = inv.m_8020_(i);
            Ingredient foundIng = null;
            for (Ingredient ing : this.recipeItems) {
                if (!ing.test(item)) continue;
                foundIng = ing;
                break;
            }
            if (foundIng == null) continue;
            found.add(foundIng);
        }
        ImmutableMultiset foundMS = ImmutableMultiset.copyOf((Iterable)found.stream().map(Ingredient::m_43942_).collect(Collectors.toList()));
        ImmutableMultiset recipeMS = ImmutableMultiset.copyOf((Iterable)this.recipeItems.stream().map(Ingredient::m_43942_).collect(Collectors.toList()));
        return NoMCRomRecipe.foundMatchRecipe(foundMS, recipeMS);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    @NotNull
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_5874_(Container p_77572_1_) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return true;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipesInit.ROOM_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return RecipesInit.ROOM;
    }

    @Override
    public int compareTo(@NotNull RoomRecipe roomRecipe) {
        int compare = Ints.compare((int)this.m_7527_().size(), (int)roomRecipe.m_7527_().size());
        if (compare == 0) {
            return Ints.compare((int)this.recipeStrength, (int)roomRecipe.recipeStrength);
        }
        return compare;
    }

    public boolean isFarmRecipe() {
        return this.farm;
    }

    public static class Type
    implements RecipeType<RoomRecipe> {
        public static final Type INSTANCE = new Type();
        public static final ResourceLocation ID = new ResourceLocation("roomrecipes", "room");
    }

    public static class Serializer
    implements RecipeSerializer<RoomRecipe> {
        public RoomRecipe fromJson(ResourceLocation recipeLoc, JsonObject recipeJson, ICondition.IContext context) {
            return this.fromJson(recipeLoc, recipeJson);
        }

        @NotNull
        public RoomRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)ingredients.size(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            int strength = 1;
            if (json.has("recipe_strength")) {
                strength = json.get("recipe_strength").getAsInt();
            }
            boolean farm = false;
            if (json.has("farm")) {
                farm = json.get("farm").getAsBoolean();
            }
            return new RoomRecipe(recipeId, (NonNullList<Ingredient>)inputs, strength, farm);
        }

        @Nullable
        public RoomRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int rSize = buffer.readInt();
            NonNullList inputs = NonNullList.m_122780_((int)rSize, (Object)Ingredient.f_43901_);
            for (int i = 0; i < rSize; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            int recipeStrength = buffer.readInt();
            boolean farm = buffer.readBoolean();
            return new RoomRecipe(recipeId, (NonNullList<Ingredient>)inputs, recipeStrength, farm);
        }

        public void toNetwork(FriendlyByteBuf buffer, RoomRecipe recipe) {
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buffer);
            }
            buffer.writeInt(recipe.recipeStrength);
            buffer.writeBoolean(recipe.farm);
        }
    }
}

