/*
 * Decompiled with CFR 0.152.
 */
package ca.bradj.roomrecipes.rooms;

import ca.bradj.roomrecipes.core.space.Position;
import ca.bradj.roomrecipes.logic.Direction;
import ca.bradj.roomrecipes.logic.interfaces.WallDetector;
import ca.bradj.roomrecipes.rooms.Wall;
import ca.bradj.roomrecipes.rooms.ZWall;
import java.util.Objects;

public class XWall
implements Wall<XWall> {
    public final Position westCorner;
    public final Position eastCorner;

    public XWall(Position westCorner, Position eastCorner) {
        Position wc = westCorner;
        Position ec = eastCorner;
        if (wc.x > ec.x) {
            wc = eastCorner;
            ec = westCorner;
        }
        this.westCorner = wc;
        this.eastCorner = ec;
    }

    public int getLength() {
        return this.eastCorner.x - this.westCorner.x;
    }

    public XWall shortenWestEnd(int i) {
        return new XWall(this.westCorner.WithX(this.westCorner.x + i), this.eastCorner);
    }

    public XWall shortenEastEnd(int i) {
        return new XWall(this.westCorner, this.eastCorner.WithX(this.eastCorner.x - i));
    }

    public XWall extendWestEnd(int i) {
        return this.shortenWestEnd(-i);
    }

    public XWall extendEastEnd(int i) {
        return this.shortenEastEnd(-i);
    }

    public XWall shiftedNorthBy(int i) {
        return this.shiftedSouthBy(-i);
    }

    public XWall shiftedSouthBy(int i) {
        return new XWall(this.westCorner.offset(0, i), this.eastCorner.offset(0, i));
    }

    public int getZ() {
        return this.westCorner.z;
    }

    public String toString() {
        return "XWall{westCorner=" + this.westCorner + ", eastCorner=" + this.eastCorner + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XWall xWall = (XWall)o;
        return Objects.equals(this.westCorner, xWall.westCorner) && Objects.equals(this.eastCorner, xWall.eastCorner);
    }

    public int hashCode() {
        return Objects.hash(this.westCorner, this.eastCorner);
    }

    public Position getMidpoint() {
        return new Position((this.westCorner.x + this.eastCorner.x) / 2, this.getZ());
    }

    public boolean sameWidth(XWall southOpening) {
        return this.westCorner.x == southOpening.westCorner.x && this.eastCorner.x == southOpening.eastCorner.x;
    }

    public boolean isSameContentAs(XWall shifted, WallDetector wd) {
        for (int i = 0; i < shifted.westCorner.x; ++i) {
            boolean shiftedIsWall;
            boolean isWall = wd.IsWall(this.westCorner.offset(i, 0));
            if (isWall == (shiftedIsWall = wd.IsWall(shifted.westCorner.offset(i, 0)))) continue;
            return false;
        }
        return true;
    }

    public boolean isLargerThan(XWall xWall) {
        return this.eastCorner.x - this.westCorner.x > xWall.eastCorner.x - xWall.westCorner.x;
    }

    @Override
    public boolean sameLengthOnAxis(Wall<?> wall) {
        return this.sameWidth(wall.toXWall());
    }

    @Override
    public XWall shiftedNegative(int i) {
        return this.shiftedNorthBy(i);
    }

    @Override
    public XWall shiftedPositive(int i) {
        return this.shiftedSouthBy(i);
    }

    @Override
    public XWall extendNegative(int i) {
        return this.extendWestEnd(i);
    }

    @Override
    public XWall extendPositive(int i) {
        return this.extendEastEnd(i);
    }

    @Override
    public XWall toXWall() {
        return this;
    }

    @Override
    public ZWall toZWall() {
        throw new IllegalStateException("Cannot convert XWall to ZWall");
    }

    @Override
    public boolean isLargerOnAxis(Wall<?> wall) {
        return this.isLargerThan(wall.toXWall());
    }

    @Override
    public boolean isSameContentOnAxis(Wall<?> w, WallDetector wd) {
        return this.isSameContentAs(w.toXWall(), wd);
    }

    @Override
    public Wall<?> shifted(Direction s, int i) {
        return switch (s) {
            case Direction.NORTH -> this.shiftedNorthBy(i);
            case Direction.SOUTH -> this.shiftedSouthBy(i);
            default -> throw new IllegalStateException("Xwall cannot be shifted west or east");
        };
    }

    @Override
    public Position negativeCorner() {
        return this.westCorner;
    }

    @Override
    public Position positiveCorner() {
        return this.eastCorner;
    }

    @Override
    public XWall shortenNegative(int i) {
        return this.shortenWestEnd(i);
    }

    @Override
    public XWall shortenPositive(int i) {
        return this.shortenEastEnd(i);
    }

    @Override
    public int getLengthOnAxis() {
        return this.getLength();
    }

    @Override
    public String toShortString() {
        return String.format("%s->%s", this.westCorner.getUIString(), this.eastCorner.getUIString());
    }
}

