/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;

public class HelpCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public HelpCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!(player.isOp() || player.hasPermission("dp.help") || this.plugin.getConfigManager().isPermissionAllPlayerHelp())) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        sender.sendMessage("\u00a7b\u00a7l[DeathPulse]\u00a7r \u00a7cPlugin Commands:");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e reload\u00a7f - Reloads the plugin configuration without restarting the server.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e setConfig\u00a7a <path> <value>\u00a7f - Sets/Change a configuration value for the plugin just using command.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e setMaxHealth\u00a7a <player> <amount>\u00a7f - Sets the maximum health of a specified player.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e viewHealth\u00a7a <player>\u00a7f - Views the health of a specified player their debt data and death data.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e viewDeathData\u00a7f - Views your death data.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e viewDebtData\u00a7f - Views your debt data.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e resetHealth\u00a7a <player|allPlayer>\u00a7f - Resets the health of a specified player or all players to the starting health.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e matchHealth\u00a7a <player|allPlayer>\u00a7f - Matches the health of a specified player or all players based on their death data.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e removeDeathData\u00a7a <player|allPlayer>\u00a7f - Removes the death data of a specified player or all players.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e removeDebtData\u00a7a <player|allPlayer>\u00a7f - Removes the debt data of a specified player or all players.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e transferHealth\u00a7a <player> <amount>\u00a7f - Transfers health to another player.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e withdrawHealth\u00a7a <amount>\u00a7f - Withdraws health from a your health to make HealthItem.");
        sender.sendMessage("/\u00a7cDeathPulse\u00a7e help\u00a7f - Shows this help message.");
        sender.sendMessage("\u00a7cAvailable Worlds that allow Death Day\u00a7f:");
        for (World world : this.plugin.getConfigManager().getConfiguredWorlds()) {
            sender.sendMessage("- \u00a7e" + String.valueOf(world));
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a7cPriority to Check for Death\u00a7f:");
        for (String priority : this.plugin.getConfigManager().getPriority()) {
            sender.sendMessage("- \u00a7e" + priority);
        }
        sender.sendMessage("");
        sender.sendMessage("\u00a7cHealth Settings\u00a7f:");
        sender.sendMessage("- \u00a7eStart Health: " + this.plugin.getConfigManager().getHPStart());
        sender.sendMessage("- \u00a7eMax Health: " + String.valueOf(this.plugin.getConfigManager().isMaxHPEnabled() ? Integer.valueOf(this.plugin.getConfigManager().getMaxHPAmount()) : "\u00a7cDisabled \u00a7f(Players Have No Health Limits)"));
        sender.sendMessage("- \u00a7eMin Health: " + String.valueOf(this.plugin.getConfigManager().isMinHPEnabled() ? Integer.valueOf(this.plugin.getConfigManager().getMinHPAmount()) : "\u00a7cDisabled \u00a7f(Zero Health Can Make You Got Banned)"));
        sender.sendMessage("- \u00a7eHealth Items: " + this.plugin.getConfigManager().getHealthItemHealthPerItem() + " Health per Item");
        sender.sendMessage("");
        EntityDamageEvent.DamageCause[] allDamageCauses = EntityDamageEvent.DamageCause.values();
        sender.sendMessage("\u00a7cAvailable All Death Causes:");
        for (EntityDamageEvent.DamageCause cause : allDamageCauses) {
            sender.sendMessage("- \u00a7e" + cause.name());
        }
        sender.sendMessage("- \u00a7ePLAYER_ATTACK");
        sender.sendMessage("- \u00a7ePLAYER_SWEEP_ATTACK");
        sender.sendMessage("- \u00a7ePLAYER_PROJECTILE");
        sender.sendMessage("- \u00a7ePLAYER_EXPLOSION");
        sender.sendMessage("");
        sender.sendMessage("\u00a7cDeath Cause Ignored\u00a7f:");
        if (this.plugin.getConfigManager().isIgnoredEnabled()) {
            for (String deathIgnored : this.plugin.getConfigManager().getIgnoredCause()) {
                sender.sendMessage("- \u00a7e" + deathIgnored);
            }
        } else {
            sender.sendMessage("\u00a7cDisabled");
        }
        sender.sendMessage("\u00a7cDay Ignored\u00a7f:");
        if (this.plugin.getConfigManager().isIgnoredDayEnabled()) {
            for (Integer day : this.plugin.getConfigManager().getIgnoredDays()) {
                sender.sendMessage("- \u00a7eDay " + day);
            }
            sender.sendMessage("\u00a7cIgnored Day Death Causes:");
            for (String dayIgnored : this.plugin.getConfigManager().getIgnoredDayCause()) {
                sender.sendMessage("- \u00a7e" + dayIgnored);
            }
        } else {
            sender.sendMessage("\u00a7cDisabled");
        }
        sender.sendMessage("\u00a7cDeath Cause Increase\u00a7f:");
        if (this.plugin.getConfigManager().isIncreaseEnabled()) {
            for (String deathIncrease : this.plugin.getConfigManager().getIncreaseCauseName()) {
                sender.sendMessage("- \u00a7e" + deathIncrease + ": " + this.plugin.getConfigManager().getIncreaseCauseAmount(deathIncrease) + " Health");
            }
        } else {
            sender.sendMessage("\u00a7cDisabled");
        }
        sender.sendMessage("\u00a7cDay Increase\u00a7f:");
        if (this.plugin.getConfigManager().isIncreaseDayEnabled()) {
            for (Integer day : this.plugin.getConfigManager().getIncreaseDays()) {
                sender.sendMessage("- \u00a7eDay " + day);
            }
            sender.sendMessage("\u00a7cIncrease Day Death Causes:");
            for (String dayIncrease : this.plugin.getConfigManager().getIncreaseDayCauseName()) {
                sender.sendMessage("- \u00a7e" + dayIncrease + ": " + this.plugin.getConfigManager().getIncreaseDayCauseAmount(dayIncrease) + " Health");
            }
        } else {
            sender.sendMessage("\u00a7cDisabled");
        }
        sender.sendMessage("\u00a7cDeath Cause Decrease\u00a7f:");
        if (this.plugin.getConfigManager().isDecreaseEnabled()) {
            for (String deathDecrease : this.plugin.getConfigManager().getDecreaseCauseName()) {
                sender.sendMessage("- \u00a7e" + deathDecrease + ": " + this.plugin.getConfigManager().getDecreaseCauseAmount(deathDecrease) + " Health");
            }
        } else {
            sender.sendMessage("\u00a7cDisabled");
        }
        sender.sendMessage("\u00a7cDay Decrease\u00a7f:");
        if (this.plugin.getConfigManager().isDecreaseDayEnabled()) {
            for (Integer day : this.plugin.getConfigManager().getDecreaseDays()) {
                sender.sendMessage("- \u00a7eDay " + day);
            }
            sender.sendMessage("\u00a7cDecrease Day Death Causes:");
            for (String dayDecrease : this.plugin.getConfigManager().getDecreaseDayCauseName()) {
                sender.sendMessage("- \u00a7e" + dayDecrease + ": " + this.plugin.getConfigManager().getDecreaseDayCauseAmount(dayDecrease) + " Health");
            }
        } else {
            sender.sendMessage("\u00a7cDisabled");
        }
        return true;
    }
}

