/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class MainCommandCompleter
implements TabCompleter {
    private final DeathPulse plugin;

    public MainCommandCompleter(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        ArrayList<String> commands = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("dp.reload") || this.plugin.getConfigManager().isPermissionAllPlayerReload()) {
                commands.add("reload");
            }
            if (sender.hasPermission("dp.setConfig") || this.plugin.getConfigManager().isPermissionAllPlayerSetConfig()) {
                commands.add("setConfig");
            }
            if (sender.hasPermission("dp.setMaxHealth") || this.plugin.getConfigManager().isPermissionAllPlayerSetMaxHealth()) {
                commands.add("setMaxHealth");
            }
            if (sender.hasPermission("dp.viewHealth") || this.plugin.getConfigManager().isPermissionAllPlayerViewHealth()) {
                commands.add("viewHealth");
            }
            if (sender.hasPermission("dp.viewDeathData") || this.plugin.getConfigManager().isPermissionAllPlayerViewDeathData()) {
                commands.add("viewDeathData");
            }
            if (sender.hasPermission("dp.viewDebtData") || this.plugin.getConfigManager().isPermissionAllPlayerViewDebtData()) {
                commands.add("viewDebtData");
            }
            if (sender.hasPermission("dp.resetHealth") || this.plugin.getConfigManager().isPermissionAllPlayerResetHealth()) {
                commands.add("resetHealth");
            }
            if (sender.hasPermission("dp.matchHealth") || this.plugin.getConfigManager().isPermissionAllPlayerMatchHealth()) {
                commands.add("matchHealth");
            }
            if (sender.hasPermission("dp.removeDeathData") || this.plugin.getConfigManager().isPermissionAllPlayerRemoveDeathData()) {
                commands.add("removeDeathData");
            }
            if (sender.hasPermission("dp.removeDebtData") || this.plugin.getConfigManager().isPermissionAllPlayerRemoveDebtData()) {
                commands.add("removeDebtData");
            }
            if (sender.hasPermission("dp.transferHealth") || this.plugin.getConfigManager().isPermissionAllPlayerTransferHealth()) {
                commands.add("transferHealth");
            }
            if (sender.hasPermission("dp.withdrawHealth") || this.plugin.getConfigManager().isPermissionAllPlayerWithdrawHealth()) {
                commands.add("withdrawHealth");
            }
            if (sender.hasPermission("dp.help") || this.plugin.getConfigManager().isPermissionAllPlayerHelp()) {
                commands.add("help");
            }
            for (String commandOption : commands) {
                if (!commandOption.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(commandOption);
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("setMaxHealth") || args[0].equalsIgnoreCase("viewHealth") || args[0].equalsIgnoreCase("resetHealth") || args[0].equalsIgnoreCase("matchHealth") || args[0].equalsIgnoreCase("removeDeathData") || args[0].equalsIgnoreCase("removeDebtData") || args[0].equalsIgnoreCase("transferHealth")) {
                if (args[0].equalsIgnoreCase("resetHealth") || args[0].equalsIgnoreCase("matchHealth") || args[0].equalsIgnoreCase("removeDeathData") || args[0].equalsIgnoreCase("removeDebtData")) {
                    completions.add("allPlayer");
                    for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                        if (offlinePlayer.isOnline()) continue;
                        completions.add(offlinePlayer.getUniqueId().toString());
                    }
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    completions.add(player.getName());
                }
            }
            if (args[0].equalsIgnoreCase("withdrawHealth")) {
                completions.add("[<amount>]");
            }
            if (args[0].equalsIgnoreCase("setConfig")) {
                completions.addAll(this.plugin.getConfigManager().getAllConfigPaths());
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("setMaxHealth") || args[0].equalsIgnoreCase("transferHealth")) {
                completions.add("[<amount>]");
            }
            if (args[0].equalsIgnoreCase("setConfig")) {
                String path = args[1];
                Object val = this.plugin.getConfig().get(path);
                if (val instanceof Boolean) {
                    completions.addAll(List.of("true", "false"));
                } else if (val instanceof List) {
                    completions.addAll(List.of("add", "remove"));
                } else if (val instanceof String) {
                    completions.add("\"your string here\"");
                } else if (val instanceof Integer) {
                    completions.add("[<number>]");
                }
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("setConfig") && this.plugin.getConfig().get(args[1]) instanceof List) {
            completions.add("<value>");
        }
        return completions;
    }
}

