/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.HealthManager;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class ViewHealthCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public ViewHealthCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!(player.isOp() || player.hasPermission("dp.viewHealth") || this.plugin.getConfigManager().isPermissionAllPlayerViewHealth())) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b viewHealth\u00a7f <player>");
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)args[1]);
        if (targetPlayer == null) {
            sender.sendMessage("\u00a7fPlayer\u00a7b " + args[1] + "\u00a7c not found\u00a7f or\u00a7c not online\u00a7f.");
            return true;
        }
        double currentHealth = HealthManager.getHealth(targetPlayer);
        double maxPlayerHealth = HealthManager.getMaxHealth(targetPlayer);
        sender.sendMessage("\u00a7b" + targetPlayer.getName() + "\u00a7f currently has\u00a7d " + currentHealth + "\u00a7f health out of\u00a7d " + maxPlayerHealth + "\u00a7f their max health.");
        UUID targetUUID = targetPlayer.getUniqueId();
        Set<String> deathData = this.plugin.getDeathDataManager().loadPlayerDeaths(targetUUID);
        int debt = this.plugin.getDebtDataManager().getDebt(targetUUID);
        sender.sendMessage("\u00a7b" + targetPlayer.getName() + "\u00a7f has\u00a7d " + debt + "\u00a7f debt.");
        if (deathData.isEmpty()) {
            sender.sendMessage("\u00a7b" + targetPlayer.getName() + "\u00a7c has no recorded\u00a7f death data.");
        } else {
            sender.sendMessage("\u00a7b" + targetPlayer.getName() + "'s\u00a7f death data:\u00a7e");
            for (String deathCause : deathData) {
                sender.sendMessage("- " + deathCause);
            }
        }
        return true;
    }
}

