/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse;

import io.github.b4n9z.deathPulse.Commands.MainCommand;
import io.github.b4n9z.deathPulse.Commands.MainCommandCompleter;
import io.github.b4n9z.deathPulse.Listeners.HealthItemListener;
import io.github.b4n9z.deathPulse.Listeners.PlayerDeathListener;
import io.github.b4n9z.deathPulse.Listeners.PlayerJoinListener;
import io.github.b4n9z.deathPulse.Managers.BanManager;
import io.github.b4n9z.deathPulse.Managers.ConfigManager;
import io.github.b4n9z.deathPulse.Managers.DayManager;
import io.github.b4n9z.deathPulse.Managers.DeathDataManager;
import io.github.b4n9z.deathPulse.Managers.DebtDataManager;
import io.github.b4n9z.deathPulse.Managers.HealthItemManager;
import io.github.b4n9z.deathPulse.bStats.Metrics;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DeathPulse
extends JavaPlugin
implements CommandExecutor {
    private DeathDataManager deathDataManager;
    private DebtDataManager debtDataManager;
    private ConfigManager configManager;
    private HealthItemManager healthItemManager;
    private BanManager banManager;
    private DayManager dayManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigManager();
        this.loadHealthItemManager();
        this.loadBanManager();
        this.loadDayManager();
        this.dayManager.start();
        this.loadDeathDataManager();
        this.loadDebtDataManager();
        this.registerEvents();
        this.registerCommands();
        this.loadMetrics(23923);
        this.getLogger().info("DeathPulse plugin enabled!");
    }

    public void onDisable() {
        this.destroyDayManager();
        this.getLogger().info("DeathPulse plugin disabled!");
    }

    public void loadMetrics(int pluginId) {
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("chart_id", () -> "My value"));
    }

    public DeathDataManager getDeathDataManager() {
        if (this.deathDataManager == null) {
            throw new IllegalStateException("DeathDataManager not initialized");
        }
        return this.deathDataManager;
    }

    public DebtDataManager getDebtDataManager() {
        if (this.debtDataManager == null) {
            throw new IllegalStateException("DebtDataManager not initialized");
        }
        return this.debtDataManager;
    }

    public ConfigManager getConfigManager() {
        if (this.configManager == null) {
            throw new IllegalStateException("ConfigManager not initialized");
        }
        return this.configManager;
    }

    public HealthItemManager getHealthItemManager() {
        if (this.healthItemManager == null) {
            throw new IllegalStateException("HealthItemManager not initialized");
        }
        return this.healthItemManager;
    }

    public BanManager getBanManager() {
        if (this.banManager == null) {
            throw new IllegalStateException("BanManager not initialized");
        }
        return this.banManager;
    }

    public DayManager getDayManager() {
        if (this.dayManager == null) {
            throw new IllegalStateException("DayWarningManager not initialized");
        }
        return this.dayManager;
    }

    public void loadConfigManager() {
        this.configManager = new ConfigManager((Plugin)this);
    }

    public void loadDeathDataManager() {
        this.deathDataManager = new DeathDataManager((Plugin)this);
    }

    public void loadDebtDataManager() {
        this.debtDataManager = new DebtDataManager((Plugin)this);
    }

    public void loadHealthItemManager() {
        this.healthItemManager = new HealthItemManager(this);
    }

    public void loadBanManager() {
        this.banManager = new BanManager(this);
    }

    public void loadDayManager() {
        this.dayManager = new DayManager(this);
        this.dayManager.firstTimeSetup();
    }

    public void destroyDayManager() {
        if (this.dayManager == null) {
            return;
        }
        this.dayManager.stop();
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HealthItemListener(this), (Plugin)this);
    }

    private void registerCommands() {
        MainCommand mainCommand = new MainCommand(this);
        Objects.requireNonNull(this.getCommand("DeathPulse")).setExecutor((CommandExecutor)mainCommand);
        Objects.requireNonNull(this.getCommand("dp")).setExecutor((CommandExecutor)mainCommand);
        MainCommandCompleter mainCommandCompleter = new MainCommandCompleter(this);
        Objects.requireNonNull(this.getCommand("DeathPulse")).setTabCompleter((TabCompleter)mainCommandCompleter);
        Objects.requireNonNull(this.getCommand("dp")).setTabCompleter((TabCompleter)mainCommandCompleter);
    }

    public void sendColoredMessageToConsole(String message) {
        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        console.sendMessage(message);
    }
}

