/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Managers;

import io.github.b4n9z.deathPulse.DeathPulse;
import java.util.Date;
import java.util.Objects;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.profile.PlayerProfile;

public class BanManager {
    private final DeathPulse plugin;

    public BanManager(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public void banPlayer(Player player, long durationInMillis) {
        PlayerProfile playerProfile;
        Date banTime = new Date(System.currentTimeMillis() + durationInMillis);
        BanList banList = Bukkit.getServer().getBanList(BanList.Type.PROFILE);
        BanEntry banEntry = banList.getBanEntry((Object)(playerProfile = player.getPlayerProfile()));
        if (banEntry == null) {
            banList.addBan((Object)playerProfile, this.plugin.getConfigManager().getNotificationPlayerBanReason(), banTime, null);
        } else {
            banEntry.setExpiration(banTime);
        }
        this.plugin.sendColoredMessageToConsole(this.plugin.getConfigManager().getNotificationConsoleBanReason().replace("{name}", player.getName()));
        player.kickPlayer(this.plugin.getConfigManager().getNotificationPlayerKicked());
    }

    public void banPlayerPermanently(Player player) {
        PlayerProfile playerProfile;
        BanList banList = Bukkit.getServer().getBanList(BanList.Type.PROFILE);
        BanEntry banEntry = banList.getBanEntry((Object)(playerProfile = player.getPlayerProfile()));
        if (banEntry == null) {
            banList.addBan((Object)playerProfile, this.plugin.getConfigManager().getNotificationPlayerBanReason(), (Date)null, null);
        } else {
            banEntry.setExpiration(null);
        }
        this.plugin.sendColoredMessageToConsole(this.plugin.getConfigManager().getNotificationConsoleBanReason().replace("{name}", player.getName()));
        player.kickPlayer(this.plugin.getConfigManager().getNotificationPlayerKicked());
    }

    public void banOfflinePlayer(OfflinePlayer player, long durationInMillis) {
        PlayerProfile playerProfile;
        Date banTime = new Date(System.currentTimeMillis() + durationInMillis);
        BanList banList = Bukkit.getServer().getBanList(BanList.Type.PROFILE);
        BanEntry banEntry = banList.getBanEntry((Object)(playerProfile = player.getPlayerProfile()));
        if (banEntry == null) {
            banList.addBan((Object)playerProfile, this.plugin.getConfigManager().getNotificationPlayerBanReason(), banTime, null);
        } else {
            banEntry.setExpiration(banTime);
        }
        this.plugin.sendColoredMessageToConsole(this.plugin.getConfigManager().getNotificationConsoleBanReason().replace("{name}", Objects.requireNonNull(player.getName(), "One Player")));
    }

    public void banOfflinePlayerPermanently(OfflinePlayer player) {
        PlayerProfile playerProfile;
        BanList banList = Bukkit.getServer().getBanList(BanList.Type.PROFILE);
        BanEntry banEntry = banList.getBanEntry((Object)(playerProfile = player.getPlayerProfile()));
        if (banEntry == null) {
            banList.addBan((Object)playerProfile, this.plugin.getConfigManager().getNotificationPlayerBanReason(), (Date)null, null);
        } else {
            banEntry.setExpiration(null);
        }
        this.plugin.sendColoredMessageToConsole(this.plugin.getConfigManager().getNotificationConsoleBanReason().replace("{name}", Objects.requireNonNull(player.getName(), "One Player")));
    }

    public void unbanPlayer(OfflinePlayer player) {
        BanList banList = Bukkit.getServer().getBanList(BanList.Type.PROFILE);
        PlayerProfile playerProfile = player.getPlayerProfile();
        banList.pardon((Object)playerProfile);
    }

    public boolean isPlayerBanned(OfflinePlayer player) {
        BanList banList = Bukkit.getServer().getBanList(BanList.Type.PROFILE);
        PlayerProfile playerProfile = player.getPlayerProfile();
        return banList.isBanned((Object)playerProfile);
    }
}

