/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Managers;

import io.github.b4n9z.deathPulse.DeathPulse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DayManager {
    private final DeathPulse plugin;
    private int taskId = -1;
    private final Map<UUID, Set<String>> warnedDays = new HashMap<UUID, Set<String>>();
    private final Set<String> lastCheckedDay = ConcurrentHashMap.newKeySet();
    private final Map<String, Boolean> dayTypeCache = Collections.synchronizedMap(new LinkedHashMap<String, Boolean>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 100;
        }
    });

    public DayManager(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public void start() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
        }
        this.taskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::checkAndWarnPlayers, 0L, 20L * this.plugin.getConfigManager().getCheckDayPeriod()).getTaskId();
    }

    public void stop() {
        if (this.taskId != -1) {
            Bukkit.getScheduler().cancelTask(this.taskId);
            this.taskId = -1;
        }
        this.warnedDays.clear();
        this.lastCheckedDay.clear();
        this.dayTypeCache.clear();
    }

    private void checkAndWarnPlayers() {
        for (World world : this.plugin.getConfigManager().getConfiguredWorlds()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.processWorld(world));
        }
    }

    private void processWorld(World world) {
        String worldName = world.getName();
        int realDay = this.getCurrentDay(world, "real");
        int gameDay = this.getCurrentDay(world, "minecraft");
        String dayKey = worldName + "_g" + gameDay + "_r" + realDay;
        if (this.lastCheckedDay.contains(dayKey)) {
            return;
        }
        if (this.lastCheckedDay.size() > 1000) {
            this.lastCheckedDay.clear();
        }
        this.lastCheckedDay.add(dayKey);
        boolean status = false;
        for (String deathType : this.plugin.getConfigManager().getPriority()) {
            if (deathType.equalsIgnoreCase("IGNORE")) {
                status = this.processDayType(world, "ignored");
            } else if (deathType.equalsIgnoreCase("INCREASE")) {
                status = this.processDayType(world, "increase");
            } else if (deathType.equalsIgnoreCase("DECREASE")) {
                status = this.processDayType(world, "decrease");
            }
            if (!status) continue;
            break;
        }
        this.processDayType(world, "season");
    }

    private boolean processDayType(World world, String type) {
        boolean isDecreaseDay;
        boolean isIncreaseDay;
        if (world == null || !this.isDayTypeEnabled(type) || !this.isMultipleDay(world, type)) {
            return false;
        }
        boolean isIgnoredDay = this.isMultipleDay(world, "ignored");
        if (this.shouldSkipDayType(type, isIgnoredDay, isIncreaseDay = this.isMultipleDay(world, "increase"), isDecreaseDay = this.isMultipleDay(world, "decrease"))) {
            return false;
        }
        if (type.equals("season") && this.plugin.getConfigManager().isResetWorldDay()) {
            long daysFirst = System.currentTimeMillis() / 86400000L - 1L;
            this.plugin.getConfigManager().setFirstTimeSetup((int)daysFirst);
            world.setTime(0L);
        }
        String dayKey = type + "_" + this.getCurrentDay(world, this.getTypeDays(type));
        String message = this.getWarningMessage(type);
        if (message == null) {
            return false;
        }
        ArrayList players = new ArrayList(world.getPlayers());
        int batchSize = 100;
        for (int i = 0; i < players.size(); i += batchSize) {
            int start = i;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                for (int j = start; j < Math.min(start + batchSize, players.size()); ++j) {
                    Player player = (Player)players.get(j);
                    if (this.hasBeenWarned(player.getUniqueId(), dayKey)) continue;
                    player.sendMessage(message);
                    player.sendTitle("\u00a7eDay \u00a7c" + this.getCurrentDay(world, this.getTypeDays(type)) + "\u00a7f!", "", 10, 70, 20);
                    player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
                    this.markAsWarned(player.getUniqueId(), dayKey);
                }
            });
        }
        return true;
    }

    public boolean processDayTypePerPlayer(Player player, String type) {
        World world = player.getWorld();
        if (this.isDayTypeEnabled(type) && this.isMultipleDay(world, type)) {
            boolean isDecreaseDay;
            boolean isIncreaseDay;
            boolean isIgnoredDay = this.isMultipleDay(world, "ignored");
            if (this.shouldSkipDayType(type, isIgnoredDay, isIncreaseDay = this.isMultipleDay(world, "increase"), isDecreaseDay = this.isMultipleDay(world, "decrease"))) {
                return false;
            }
            String dayKey = type + "_" + this.getCurrentDay(world, this.getTypeDays(type));
            if (this.hasBeenWarned(player.getUniqueId(), dayKey)) {
                return false;
            }
            String message = this.getWarningMessage(type);
            if (message == null) {
                return false;
            }
            player.sendMessage(message);
            player.sendTitle("\u00a7eDay \u00a7c" + this.getCurrentDay(world, this.getTypeDays(type)) + "\u00a7f!", "", 10, 70, 20);
            player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
            this.markAsWarned(player.getUniqueId(), dayKey);
            return true;
        }
        return false;
    }

    private boolean isDayTypeEnabled(String type) {
        return switch (type.toLowerCase()) {
            case "ignored" -> this.plugin.getConfigManager().isIgnoredDayEnabled();
            case "increase" -> this.plugin.getConfigManager().isIncreaseDayEnabled();
            case "decrease" -> this.plugin.getConfigManager().isDecreaseDayEnabled();
            case "season" -> this.plugin.getConfigManager().isSeasonEnabled();
            default -> false;
        };
    }

    private boolean hasBeenWarned(UUID playerId, String dayKey) {
        return this.warnedDays.getOrDefault(playerId, Collections.emptySet()).contains(dayKey);
    }

    private void markAsWarned(UUID playerId, String dayKey) {
        this.warnedDays.computeIfAbsent(playerId, k -> new HashSet()).add(dayKey);
    }

    private String getWarningMessage(String type) {
        return switch (type.toLowerCase()) {
            case "ignored" -> this.plugin.getConfigManager().getIgnoredDayWarning();
            case "increase" -> this.plugin.getConfigManager().getIncreaseDayWarning();
            case "decrease" -> this.plugin.getConfigManager().getDecreaseDayWarning();
            case "season" -> this.plugin.getConfigManager().getSeasonChangeWarning();
            default -> null;
        };
    }

    public int getSeason(World world, String type) {
        Iterator<Integer> iterator;
        int currentDay = this.getCurrentDay(world, this.getTypeDays(type));
        List<Integer> days = this.getDaysForType(type);
        int season = 1;
        if (this.isMultipleDay(world, type) && (iterator = days.iterator()).hasNext()) {
            int day = iterator.next();
            return currentDay / day + 1;
        }
        return season;
    }

    public int getCurrentDay(World world, String dayType) {
        if ("real".equalsIgnoreCase(dayType)) {
            long currentTimeMillis = System.currentTimeMillis();
            return (int)(currentTimeMillis / 86400000L) - this.plugin.getConfigManager().getFirstTimeSetup();
        }
        return (int)(world.getFullTime() / this.plugin.getConfigManager().getTicksPerDay(world));
    }

    public boolean isMultipleDay(World world, String type) {
        int currentDay = this.getCurrentDay(world, this.getTypeDays(type));
        String cacheKey = world.getName() + "_" + type + "_" + currentDay;
        if (this.dayTypeCache.containsKey(cacheKey)) {
            return this.dayTypeCache.get(cacheKey);
        }
        List<Integer> days = this.getDaysForType(type);
        boolean result = false;
        for (int day : days) {
            if (currentDay % day != 0 || currentDay == 0) continue;
            result = true;
            break;
        }
        this.dayTypeCache.put(cacheKey, result);
        return result;
    }

    public String getTypeDays(String type) {
        return switch (type.toLowerCase()) {
            case "ignored" -> this.plugin.getConfigManager().getIgnoredDayType();
            case "increase" -> this.plugin.getConfigManager().getIncreaseDayType();
            case "decrease" -> this.plugin.getConfigManager().getDecreaseDayType();
            default -> this.plugin.getConfigManager().getSeasonType();
        };
    }

    private List<Integer> getDaysForType(String type) {
        ArrayList<Integer> seasonDayList = new ArrayList<Integer>();
        seasonDayList.add(this.plugin.getConfigManager().getSeasonDay());
        return switch (type.toLowerCase()) {
            case "ignored" -> this.plugin.getConfigManager().getIgnoredDays();
            case "increase" -> this.plugin.getConfigManager().getIncreaseDays();
            case "decrease" -> this.plugin.getConfigManager().getDecreaseDays();
            default -> seasonDayList;
        };
    }

    public void firstTimeSetup() {
        if (this.plugin.getConfigManager().getFirstTimeSetup() != 0) {
            return;
        }
        long daysFirst = System.currentTimeMillis() / 86400000L - 1L;
        this.plugin.getConfigManager().setFirstTimeSetup((int)daysFirst);
    }

    private boolean shouldSkipDayType(String current, boolean ignored, boolean increase, boolean decrease) {
        return switch (current.toLowerCase()) {
            case "ignored" -> {
                if (increase && this.plugin.getConfigManager().isIncreaseDayDeActiveIgnoredDay() || decrease && this.plugin.getConfigManager().isDecreaseDayDeActiveIgnoredDay()) {
                    yield true;
                }
                yield false;
            }
            case "increase" -> {
                if (ignored && this.plugin.getConfigManager().isIgnoredDayDeActiveIncreaseDay() || decrease && this.plugin.getConfigManager().isDecreaseDayDeActiveIncreaseDay()) {
                    yield true;
                }
                yield false;
            }
            case "decrease" -> {
                if (ignored && this.plugin.getConfigManager().isIgnoredDayDeActiveDecreaseDay() || increase && this.plugin.getConfigManager().isIncreaseDayDeActiveDecreaseDay()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

