/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Managers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DeathDataManager {
    private final Plugin plugin;
    private final Gson gson = new Gson();
    private final File dataFolder;
    private final Map<UUID, Set<String>> playerDeathCache = new HashMap<UUID, Set<String>>();
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<UUID, Map<Integer, Integer>> playerDailyDeathCounter = new HashMap<UUID, Map<Integer, Integer>>();

    public DeathDataManager(Plugin plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "death_data");
        if (!this.dataFolder.exists() && !this.dataFolder.mkdirs()) {
            throw new RuntimeException("Failed to create data directory: " + this.dataFolder.getAbsolutePath());
        }
    }

    public boolean logDeath(UUID playerUUID, String deathCause) {
        Set deathCauses = this.playerDeathCache.computeIfAbsent(playerUUID, this::loadPlayerDeaths);
        boolean isNewDeath = deathCauses.add(deathCause);
        this.savePlayerDeaths(playerUUID, deathCauses);
        return isNewDeath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> loadPlayerDeaths(UUID playerUUID) {
        this.lock.lock();
        try {
            Set set;
            if (this.playerDeathCache.containsKey(playerUUID)) {
                Set<String> set2 = this.playerDeathCache.get(playerUUID);
                return set2;
            }
            File file = new File(this.dataFolder, playerUUID.toString() + ".json");
            if (!file.exists()) {
                HashSet<String> hashSet = new HashSet<String>();
                return hashSet;
            }
            FileReader reader = new FileReader(file);
            try {
                Type type = new TypeToken<Set<String>>(this){}.getType();
                set = (Set)this.gson.fromJson((Reader)reader, type);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Bukkit.getLogger().severe("Failed to load death data for " + String.valueOf(playerUUID));
                    HashSet<String> hashSet = new HashSet<String>();
                    return hashSet;
                }
            }
            reader.close();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void savePlayerDeaths(UUID playerUUID, Set<String> deathCauses) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            this.lock.lock();
            try {
                File file = new File(this.dataFolder, playerUUID.toString() + ".json");
                try (FileWriter writer = new FileWriter(file);){
                    this.gson.toJson((Object)deathCauses, (Appendable)writer);
                }
                catch (IOException e) {
                    Bukkit.getLogger().severe("Failed to save death data for " + String.valueOf(playerUUID));
                }
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePlayerDeathData(UUID playerUUID) {
        if (this.lock.tryLock()) {
            try {
                this.playerDeathCache.remove(playerUUID);
                File file = new File(this.dataFolder, playerUUID.toString() + ".json");
                if (file.exists()) {
                    boolean bl = file.delete();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllDeathData() {
        if (this.lock.tryLock()) {
            try {
                this.playerDeathCache.clear();
                File[] files = this.dataFolder.listFiles((dir, name) -> name.endsWith(".json"));
                if (files != null) {
                    int count = files.length;
                    int deleted = 0;
                    for (File file : files) {
                        if (!file.delete()) continue;
                        ++deleted;
                    }
                    boolean bl = deleted == count;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    public synchronized int getNextDeathCounter(UUID playerUUID, int currentDay) {
        this.playerDailyDeathCounter.putIfAbsent(playerUUID, new HashMap());
        Map<Integer, Integer> dailyCounter = this.playerDailyDeathCounter.get(playerUUID);
        dailyCounter.put(currentDay, dailyCounter.getOrDefault(currentDay, 0) + 1);
        return dailyCounter.get(currentDay);
    }
}

