/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.mojang.serialization.MapCodec;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.common.CommonCapabilities;
import net.blay09.mods.excompressum.block.entity.AutoCompressorBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AutoCompressorBlock
extends BaseEntityBlock {
    public static final MapCodec<AutoCompressorBlock> CODEC = AutoCompressorBlock.simpleCodec(AutoCompressorBlock::new);

    public AutoCompressorBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AutoCompressorBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!player.isShiftKeyDown() && !level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            Balm.getNetworking().openMenu(player, menuProvider);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        Container container;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && (container = (Container)Balm.getCapabilities().getCapability(blockEntity, CommonCapabilities.CONTAINER)) != null) {
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)container);
        }
        return 0;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateRedstoneState(level, pos);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation orientation, boolean isMoving) {
        this.updateRedstoneState(level, pos);
    }

    private void updateRedstoneState(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof AutoCompressorBlockEntity) {
            AutoCompressorBlockEntity autoCompressor = (AutoCompressorBlockEntity)blockEntity;
            autoCompressor.setDisabledByRedstone(world.hasNeighborSignal(pos));
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide() ? AutoCompressorBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.autoCompressor.get()), AutoCompressorBlockEntity::serverTick) : null;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

