/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.excompressum.block.AutoCompressedHammerBlock;
import net.blay09.mods.excompressum.block.AutoCompressorBlock;
import net.blay09.mods.excompressum.block.AutoHammerBlock;
import net.blay09.mods.excompressum.block.AutoHeavySieveBlock;
import net.blay09.mods.excompressum.block.AutoSieveBlock;
import net.blay09.mods.excompressum.block.BaitBlock;
import net.blay09.mods.excompressum.block.BaitType;
import net.blay09.mods.excompressum.block.CompressedBlock;
import net.blay09.mods.excompressum.block.CompressedBlockType;
import net.blay09.mods.excompressum.block.HeavySieveBlock;
import net.blay09.mods.excompressum.block.HeavySieveType;
import net.blay09.mods.excompressum.block.RationingAutoCompressorBlock;
import net.blay09.mods.excompressum.block.WoodenCrucibleBlock;
import net.blay09.mods.excompressum.block.WoodenCrucibleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static Block[] compressedBlocks;
    public static Block[] heavySieves;
    public static Block[] woodenCrucibles;
    public static Block[] baits;
    public static Block autoHammer;
    public static Block autoCompressedHammer;
    public static Block autoHeavySieve;
    public static Block autoSieve;
    public static Block autoCompressor;
    public static Block rationingAutoCompressor;

    public static void initialize(BalmBlocks blocks) {
        blocks.register(identifier -> {
            autoHammer = new AutoHammerBlock(ModBlocks.defaultProperties(identifier));
            return autoHammer;
        }, (block, identifier) -> new BlockItem(block, ModBlocks.itemProperties(identifier)), ModBlocks.id("auto_hammer"));
        blocks.register(identifier -> {
            autoSieve = new AutoSieveBlock(ModBlocks.defaultProperties(identifier));
            return autoSieve;
        }, (block, identifier) -> new BlockItem(block, ModBlocks.itemProperties(identifier)), ModBlocks.id("auto_sieve"));
        blocks.register(identifier -> {
            autoCompressedHammer = new AutoCompressedHammerBlock(ModBlocks.defaultProperties(identifier));
            return autoCompressedHammer;
        }, (block, identifier) -> new BlockItem(block, ModBlocks.itemProperties(identifier)), ModBlocks.id("auto_compressed_hammer"));
        blocks.register(identifier -> {
            autoHeavySieve = new AutoHeavySieveBlock(ModBlocks.defaultProperties(identifier));
            return autoHeavySieve;
        }, (block, identifier) -> new BlockItem(block, ModBlocks.itemProperties(identifier)), ModBlocks.id("auto_heavy_sieve"));
        blocks.register(identifier -> {
            autoCompressor = new AutoCompressorBlock(ModBlocks.defaultProperties(identifier));
            return autoCompressor;
        }, (block, identifier) -> new BlockItem(block, ModBlocks.itemProperties(identifier)), ModBlocks.id("auto_compressor"));
        blocks.register(identifier -> {
            rationingAutoCompressor = new RationingAutoCompressorBlock(ModBlocks.defaultProperties(identifier));
            return rationingAutoCompressor;
        }, (block, identifier) -> new BlockItem(block, ModBlocks.itemProperties(identifier)), ModBlocks.id("rationing_auto_compressor"));
        compressedBlocks = ModBlocks.registerEnumBlock((BalmBlocks)blocks, (Enum[])CompressedBlockType.values(), (T it) -> "compressed_" + it, CompressedBlock::new);
        heavySieves = ModBlocks.registerEnumBlock((BalmBlocks)blocks, (Enum[])HeavySieveType.values(), (T it) -> it + "_heavy_sieve", HeavySieveBlock::new);
        woodenCrucibles = ModBlocks.registerEnumBlock((BalmBlocks)blocks, (Enum[])WoodenCrucibleType.values(), (T it) -> it + "_crucible", WoodenCrucibleBlock::new);
        baits = ModBlocks.registerEnumBlock((BalmBlocks)blocks, (Enum[])BaitType.values(), (T it) -> it + "_bait", BaitBlock::new);
    }

    private static <T extends Enum<T>> Block[] registerEnumBlock(BalmBlocks blocks, T[] types, Function<String, String> nameFactory, BiFunction<T, BlockBehaviour.Properties, Block> factory) {
        Block[] blockArray = new Block[types.length];
        for (Object type : types) {
            blocks.register(identifier -> {
                Block block = (Block)factory.apply(type, ModBlocks.defaultProperties(identifier));
                blockArray[type.ordinal()] = block;
                return block;
            }, (block, identifier) -> new BlockItem(block, ModBlocks.itemProperties(identifier)), ModBlocks.id(nameFactory.apply(((StringRepresentable)type).getSerializedName())));
        }
        return blockArray;
    }

    private static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)path);
    }

    private static BlockBehaviour.Properties defaultProperties(ResourceLocation identifier) {
        return BlockBehaviour.Properties.of().setId(ModBlocks.blockId(identifier));
    }

    private static Item.Properties itemProperties(ResourceLocation identifier) {
        return new Item.Properties().setId(ModBlocks.itemId(identifier));
    }

    private static ResourceKey<Block> blockId(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier);
    }

    private static ResourceKey<Item> itemId(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)identifier);
    }
}

