/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.DelegateContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.DefaultEnergyStorage;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.block.AutoHammerBlock;
import net.blay09.mods.excompressum.block.ModBlockStateProperties;
import net.blay09.mods.excompressum.block.entity.AbstractBaseBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.component.ModComponents;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.menu.AutoHammerMenu;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.hammer.HammerRegistry;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;

public class AutoHammerBlockEntity
extends AbstractBaseBlockEntity
implements BalmMenuProvider<BlockPos>,
BalmContainerProvider,
BalmEnergyStorageProvider {
    private static final int UPDATE_INTERVAL = 20;
    private final DefaultEnergyStorage energyStorage = new DefaultEnergyStorage(32000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                AutoHammerBlockEntity.this.isDirty = true;
            }
            return super.fill(maxReceive, simulate);
        }
    };
    private final ContainerData containerData = new ContainerData(){

        public int get(int id) {
            if (id == 0) {
                return (int)(100.0f * AutoHammerBlockEntity.this.getProgress());
            }
            if (id == 1) {
                return AutoHammerBlockEntity.this.getEnergyStorage().getEnergy();
            }
            if (id == 2) {
                return AutoHammerBlockEntity.this.isDisabledByRedstone() ? 1 : 0;
            }
            return 0;
        }

        public void set(int id, int value) {
            if (id == 0) {
                AutoHammerBlockEntity.this.setProgress((float)value / 100.0f);
            } else if (id == 1) {
                AutoHammerBlockEntity.this.getEnergyStorage().setEnergy(value);
            } else if (id == 2) {
                AutoHammerBlockEntity.this.setDisabledByRedstone(value == 1);
            }
        }

        public int getCount() {
            return 3;
        }
    };
    private final DefaultContainer backingContainer = new DefaultContainer(23){

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            if (AutoHammerBlockEntity.this.inputSlots.containsOuterSlot(slot)) {
                ServerLevel serverLevel;
                Level level = AutoHammerBlockEntity.this.level;
                return level instanceof ServerLevel && AutoHammerBlockEntity.this.isRegistered(serverLevel = (ServerLevel)level, itemStack);
            }
            if (AutoHammerBlockEntity.this.hammerSlots.containsOuterSlot(slot)) {
                return AutoHammerBlockEntity.this.isHammerUpgrade(itemStack);
            }
            return true;
        }

        public void slotChanged(int slot) {
            super.slotChanged(slot);
            if (AutoHammerBlockEntity.this.hammerSlots.containsOuterSlot(slot)) {
                AutoHammerBlockEntity.this.isDirty = true;
            }
        }
    };
    private final SubContainer inputSlots = new SubContainer((Container)this.backingContainer, 0, 1);
    private final SubContainer outputSlots = new SubContainer((Container)this.backingContainer, 1, 21);
    private final SubContainer hammerSlots = new SubContainer((Container)this.backingContainer, 21, 23);
    private final List<ItemStack> overflowBuffer = new ArrayList<ItemStack>();
    private final DelegateContainer container = new DelegateContainer((Container)this.backingContainer){

        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            return super.canPlaceItem(slot, itemStack) && (AutoHammerBlockEntity.this.inputSlots.containsOuterSlot(slot) || AutoHammerBlockEntity.this.hammerSlots.containsOuterSlot(slot));
        }

        public int[] getSlotsForFace(Direction direction) {
            if (direction == Direction.DOWN) {
                return AutoHammerBlockEntity.this.outputSlots.getOuterSlotsForFace(direction);
            }
            if (direction == Direction.UP) {
                return AutoHammerBlockEntity.this.inputSlots.getOuterSlotsForFace(direction);
            }
            return AutoHammerBlockEntity.this.hammerSlots.getOuterSlotsForFace(direction);
        }

        public boolean canTakeItemThroughFace(int slot, ItemStack itemStack, Direction direction) {
            return AutoHammerBlockEntity.this.outputSlots.containsOuterSlot(slot);
        }
    };
    private ItemStack currentStack = ItemStack.EMPTY;
    private int cooldown;
    private int ticksSinceUpdate;
    private boolean isDirty;
    private float progress;
    private ItemStack finishedStack = ItemStack.EMPTY;
    public float hammerAngle;
    private boolean isDisabledByRedstone;

    public AutoHammerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.autoHammer.get(), pos, state);
    }

    public AutoHammerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AutoHammerBlockEntity blockEntity) {
        blockEntity.clientTick();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AutoHammerBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void clientTick() {
        if (!this.finishedStack.isEmpty()) {
            BlockState state = StupidUtils.getStateFromItemStack(this.finishedStack);
            if (!state.isAir()) {
                ExCompressum.proxy.get().spawnCrushParticles(this.level, this.worldPosition, state);
            }
            this.finishedStack = ItemStack.EMPTY;
        }
    }

    public void serverTick() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        int effectiveEnergy = this.getEffectiveEnergy();
        if (!this.isDisabledByRedstone() && this.overflowBuffer.isEmpty() && this.getEnergyStored() >= effectiveEnergy) {
            if (this.currentStack.isEmpty() && this.cooldown <= 0) {
                ItemStack inputStack = this.inputSlots.getItem(0);
                if (!inputStack.isEmpty() && this.isRegistered((ServerLevel)this.level, inputStack)) {
                    boolean foundSpace = false;
                    for (int i = 0; i < this.outputSlots.getContainerSize(); ++i) {
                        if (!this.outputSlots.getItem(i).isEmpty()) continue;
                        foundSpace = true;
                    }
                    if (!foundSpace) {
                        return;
                    }
                    this.currentStack = inputStack.split(1);
                    if (inputStack.isEmpty()) {
                        this.inputSlots.setItem(0, ItemStack.EMPTY);
                    }
                    this.energyStorage.drain(effectiveEnergy, false);
                    this.ticksSinceUpdate = 20;
                    this.progress = 0.0f;
                }
            } else {
                this.energyStorage.drain(effectiveEnergy, false);
                this.progress += this.getEffectiveSpeed();
                this.isDirty = true;
                if (this.progress >= 1.0f) {
                    if (!this.level.isClientSide()) {
                        if ((double)this.level.random.nextFloat() <= ExCompressumConfig.getActive().automation.autoHammerDecay) {
                            ItemStack secondHammer;
                            ItemStack firstHammer = this.hammerSlots.getItem(0);
                            if (!firstHammer.isEmpty()) {
                                firstHammer.hurtAndBreak(1, (ServerLevel)this.level, null, it -> this.hammerSlots.setItem(0, ItemStack.EMPTY));
                            }
                            if (!(secondHammer = this.hammerSlots.getItem(1)).isEmpty()) {
                                secondHammer.hurtAndBreak(1, (ServerLevel)this.level, null, it -> this.hammerSlots.setItem(1, ItemStack.EMPTY));
                            }
                        }
                        Collection<ItemStack> rewards = this.rollHammerRewards((ServerLevel)this.level, this.currentStack, this.getEffectiveTool(), this.level.random);
                        for (ItemStack itemStack : rewards) {
                            if (this.addItemToOutput(itemStack)) continue;
                            this.overflowBuffer.add(itemStack);
                        }
                    }
                    this.finishedStack = this.currentStack;
                    this.progress = 0.0f;
                    this.ticksSinceUpdate = 20;
                    this.cooldown = 2;
                    this.currentStack = ItemStack.EMPTY;
                }
            }
        } else if (!this.overflowBuffer.isEmpty() && this.addItemToOutput(this.overflowBuffer.getFirst())) {
            this.overflowBuffer.removeFirst();
        }
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate > 20) {
            if (this.isDirty) {
                this.sync();
                this.finishedStack = ItemStack.EMPTY;
                this.isDirty = false;
            }
            this.ticksSinceUpdate = 0;
        }
    }

    private ItemStack getEffectiveTool() {
        return Math.random() < 0.5 ? this.hammerSlots.getItem(0) : this.hammerSlots.getItem(1);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergy();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getCapacity();
    }

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 0; i < this.outputSlots.getContainerSize(); ++i) {
            ItemStack slotStack = this.outputSlots.getItem(i);
            if (slotStack.isEmpty()) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (slotStack.getCount() + itemStack.getCount() > slotStack.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)itemStack)) continue;
            slotStack.grow(itemStack.getCount());
            return true;
        }
        if (firstEmptySlot != -1) {
            this.outputSlots.setItem(firstEmptySlot, itemStack);
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ExCompressumConfig.getActive().automation.autoHammerEnergy;
    }

    public float getSpeedMultiplier() {
        ItemStack secondHammer;
        float HAMMER_BOOST = 0.5f;
        float EFFICIENCY_BOOST = 0.5f;
        float boost = 1.0f;
        Holder.Reference efficiencyEnchantment = this.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.EFFICIENCY);
        ItemStack firstHammer = this.hammerSlots.getItem(0);
        if (!firstHammer.isEmpty() && this.isHammerUpgrade(firstHammer)) {
            boost += 0.5f;
            boost += 0.5f * (float)EnchantmentHelper.getItemEnchantmentLevel((Holder)efficiencyEnchantment, (ItemStack)firstHammer);
        }
        if (!(secondHammer = this.hammerSlots.getItem(1)).isEmpty() && this.isHammerUpgrade(secondHammer)) {
            boost += 0.5f;
            boost += 0.5f * (float)EnchantmentHelper.getItemEnchantmentLevel((Holder)efficiencyEnchantment, (ItemStack)secondHammer);
        }
        return boost;
    }

    public float getEffectiveSpeed() {
        return (float)(ExCompressumConfig.getActive().automation.autoHammerSpeed * (double)this.getSpeedMultiplier());
    }

    public float getEffectiveLuck() {
        ItemStack secondHammer;
        float luck = 0.0f;
        Holder.Reference fortuneEnchantment = this.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        ItemStack firstHammer = this.hammerSlots.getItem(0);
        if (!firstHammer.isEmpty() && this.isHammerUpgrade(firstHammer)) {
            luck += (float)EnchantmentHelper.getItemEnchantmentLevel((Holder)fortuneEnchantment, (ItemStack)firstHammer);
        }
        if (!(secondHammer = this.hammerSlots.getItem(1)).isEmpty() && this.isHammerUpgrade(secondHammer)) {
            luck += (float)EnchantmentHelper.getItemEnchantmentLevel((Holder)fortuneEnchantment, (ItemStack)secondHammer);
        }
        return luck;
    }

    public void loadAdditional(ValueInput input) {
        this.currentStack = input.read("CurrentStack", ItemStack.OPTIONAL_CODEC).orElse(this.currentStack);
        this.progress = input.getFloatOr("Progress", 0.0f);
        input.child("EnergyStorage").ifPresent(it -> this.energyStorage.deserialize(it));
        input.child("ItemHandler").ifPresent(it -> ContainerHelper.loadAllItems((ValueInput)it, (NonNullList)this.backingContainer.getItems()));
        this.isDisabledByRedstone = input.getBooleanOr("IsDisabledByRedstone", false);
        this.finishedStack = input.read("FinishedStack", ItemStack.OPTIONAL_CODEC).orElse(this.finishedStack);
        input.read("FirstHammer", ItemStack.OPTIONAL_CODEC).ifPresent(hammer -> this.hammerSlots.setItem(0, hammer));
        input.read("SecondHammer", ItemStack.OPTIONAL_CODEC).ifPresent(hammer -> this.hammerSlots.setItem(1, hammer));
        this.overflowBuffer.clear();
        input.list("OverflowBuffer", ItemStack.CODEC).ifPresent(overflowItems -> {
            for (ItemStack overflowItem : overflowItems) {
                this.overflowBuffer.add(overflowItem);
            }
        });
    }

    public void saveAdditional(ValueOutput output) {
        this.energyStorage.serialize(output.child("EnergyStorage"));
        output.store("CurrentStack", ItemStack.OPTIONAL_CODEC, (Object)this.currentStack);
        output.store("FinishedStack", ItemStack.OPTIONAL_CODEC, (Object)this.finishedStack);
        output.putFloat("Progress", this.progress);
        ContainerHelper.saveAllItems((ValueOutput)output.child("ItemHandler"), (NonNullList)this.backingContainer.getItems());
        output.putBoolean("IsDisabledByRedstone", this.isDisabledByRedstone);
        ValueOutput.TypedOutputList overflowList = output.list("OverflowBuffer", ItemStack.CODEC);
        for (ItemStack itemStack : this.overflowBuffer) {
            overflowList.add((Object)itemStack);
        }
    }

    public void writeUpdateTag(ValueOutput output) {
        this.saveAdditional(output);
        output.store("FirstHammer", ItemStack.OPTIONAL_CODEC, (Object)this.hammerSlots.getItem(0));
        output.store("SecondHammer", ItemStack.OPTIONAL_CODEC, (Object)this.hammerSlots.getItem(1));
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public float getEnergyPercentage() {
        return (float)this.getEnergyStored() / (float)this.getMaxEnergyStored();
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    @Nullable
    public BlockState getCurrentBlock() {
        return StupidUtils.getStateFromItemStack(this.currentStack);
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public DefaultContainer getBackingContainer() {
        return this.backingContainer;
    }

    public Container getContainer() {
        return this.container;
    }

    public ItemStack getUpgradeStack(int i) {
        return this.hammerSlots.getItem(i);
    }

    public boolean isHammerUpgrade(ItemStack itemStack) {
        return itemStack.is(ModItemTags.HAMMERS);
    }

    public boolean isRegistered(ServerLevel level, ItemStack itemStack) {
        if (level == null) {
            return false;
        }
        RecipeManager recipeManager = level.getServer().getRecipeManager();
        return ExNihilo.isHammerable((Level)level, itemStack) || ExRegistries.getHammerRegistry().isHammerable(recipeManager, itemStack);
    }

    public Collection<ItemStack> rollHammerRewards(ServerLevel level, ItemStack itemStack, ItemStack toolItem, RandomSource rand) {
        if (level == null) {
            return Collections.emptyList();
        }
        RecipeManager recipeManager = level.getServer().getRecipeManager();
        if (ExRegistries.getHammerRegistry().isHammerable(recipeManager, itemStack)) {
            LootContext lootContext = LootTableUtils.buildLootContext(level, itemStack);
            return HammerRegistry.rollHammerRewards(lootContext, itemStack);
        }
        BlockState currentState = StupidUtils.getStateFromItemStack(itemStack);
        return ExNihilo.getInstance().rollHammerRewards((Level)level, currentState, toolItem, rand);
    }

    public boolean shouldAnimate() {
        return !this.currentStack.isEmpty() && this.getEnergyStored() >= this.getEffectiveEnergy() && !this.isDisabledByRedstone();
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public boolean isUgly() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)ModBlockStateProperties.UGLY)) {
            return (Boolean)state.getValue((Property)ModBlockStateProperties.UGLY);
        }
        return false;
    }

    public Direction getFacing() {
        BlockState state = this.getBlockState();
        if (state.hasProperty(AutoHammerBlock.FACING)) {
            return (Direction)state.getValue(AutoHammerBlock.FACING);
        }
        return Direction.NORTH;
    }

    public boolean isDisabledByRedstone() {
        return this.isDisabledByRedstone;
    }

    public void setDisabledByRedstone(boolean disabledByRedstone) {
        this.isDisabledByRedstone = disabledByRedstone;
        this.isDirty = true;
        this.ticksSinceUpdate = 20;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.excompressum.auto_hammer");
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new AutoHammerMenu(windowId, inventory, this);
    }

    public ContainerData getContainerData() {
        return this.containerData;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set((DataComponentType)ModComponents.energy.get(), (Object)this.energyStorage.getEnergy());
    }

    protected void applyImplicitComponents(DataComponentGetter input) {
        Integer energyComponent = (Integer)input.get((DataComponentType)ModComponents.energy.get());
        if (energyComponent != null) {
            this.energyStorage.setEnergy(energyComponent.intValue());
        }
    }

    public BlockPos getScreenOpeningData(ServerPlayer serverPlayer) {
        return this.worldPosition;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BlockPos> getScreenStreamCodec() {
        return BlockPos.STREAM_CODEC.cast();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        ItemStack currentStack;
        super.preRemoveSideEffects(pos, state);
        if (this.level != null && !(currentStack = this.getCurrentStack()).isEmpty()) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), currentStack));
        }
    }
}

