/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.gui;

import java.util.ArrayList;
import net.blay09.mods.excompressum.block.entity.AutoHammerBlockEntity;
import net.blay09.mods.excompressum.menu.AutoHammerMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AutoHammerScreen
extends AbstractContainerScreen<AutoHammerMenu> {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"textures/gui/auto_hammer.png");

    public AutoHammerScreen(AutoHammerMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        AutoHammerBlockEntity blockEntity = ((AutoHammerMenu)this.menu).getAutoHammer();
        if (blockEntity.isProcessing()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos + 32, this.topPos + 36, 176.0f, 0.0f, (int)(blockEntity.getProgress() * 15.0f), 14, 256, 256);
        }
        if (blockEntity.isDisabledByRedstone()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos + 44, this.topPos + 48, 176.0f, 14.0f, 15, 16, 256, 256);
        }
        float energyPercentage = blockEntity.getEnergyPercentage();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos + 152, this.topPos + 8 + (70 - (int)(energyPercentage * 70.0f)), 191.0f, 0.0f, 16, (int)(energyPercentage * 70.0f), 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (mouseX >= this.leftPos + 152 && mouseX <= this.leftPos + 167 && mouseY >= this.topPos + 8 && mouseY <= this.topPos + 77) {
            AutoHammerBlockEntity blockEntity = ((AutoHammerMenu)this.menu).getAutoHammer();
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"tooltip.excompressum.energyStored", (Object[])new Object[]{blockEntity.getEnergyStorage().getEnergy()}));
            tooltip.add(Component.translatable((String)"tooltip.excompressum.consumingEnergy", (Object[])new Object[]{blockEntity.getEffectiveEnergy()}));
            guiGraphics.setComponentTooltipForNextFrame(Minecraft.getInstance().font, tooltip, mouseX - this.leftPos, mouseY - this.topPos);
        }
    }
}

