/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import net.blay09.mods.excompressum.block.AutoHammerBlock;
import net.blay09.mods.excompressum.block.entity.AutoHammerBlockEntity;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class AutoHammerRenderer
implements BlockEntityRenderer<AutoHammerBlockEntity, AutoHammerRenderState> {
    private final ItemModelResolver itemModelResolver;
    private final boolean isCompressed;
    private ItemStack hammerItemStack = ItemStack.EMPTY;

    public AutoHammerRenderer(BlockEntityRendererProvider.Context context, boolean isCompressed) {
        this.itemModelResolver = context.itemModelResolver();
        this.isCompressed = isCompressed;
    }

    public void extractRenderState(AutoHammerBlockEntity blockEntity, AutoHammerRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        if (blockEntity.shouldAnimate()) {
            blockEntity.hammerAngle += 0.4f * delta;
        }
        renderState.skip = blockEntity.isUgly();
        renderState.facing = (Direction)renderState.blockState.getValue(AutoHammerBlock.FACING);
        renderState.progress = blockEntity.getProgress();
        renderState.hammerAngle = blockEntity.hammerAngle;
        if (this.hammerItemStack.isEmpty()) {
            if (this.isCompressed) {
                this.hammerItemStack = new ItemStack((ItemLike)ModItems.compressedDiamondHammer);
            } else {
                Iterator iterator = BuiltInRegistries.ITEM.getTagOrEmpty(ModItemTags.DIAMOND_HAMMERS).iterator();
                if (iterator.hasNext()) {
                    Holder itemHolder = (Holder)iterator.next();
                    this.hammerItemStack = new ItemStack((ItemLike)itemHolder.value());
                }
                if (this.hammerItemStack.isEmpty()) {
                    this.hammerItemStack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
                }
            }
        }
        this.itemModelResolver.updateForTopItem(renderState.hammerItem, this.hammerItemStack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        this.itemModelResolver.updateForTopItem(renderState.firstHammerItem, blockEntity.getUpgradeStack(0), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        this.itemModelResolver.updateForTopItem(renderState.secondHammerItem, blockEntity.getUpgradeStack(1), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
        this.itemModelResolver.updateForTopItem(renderState.item, blockEntity.getCurrentStack(), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
    }

    public AutoHammerRenderState createRenderState() {
        return new AutoHammerRenderState();
    }

    public void submit(AutoHammerRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.skip) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose((Quaternionfc)renderState.facing.getRotation());
        poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)-90.0f), 0.0f, 1.0f, 0.0f)));
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.pushPose();
        poseStack.translate(-0.7f, -0.3f, 0.0f);
        poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)(Math.sin((float)renderState.hammerAngle) * 30.0f)), 0.0f, 0.0f, 1.0f)));
        poseStack.translate(-0.4f, 0.2f, 0.0f);
        renderState.hammerItem.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
        if (!renderState.firstHammerItem.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.7f, -0.3f, 0.0f);
            poseStack.translate(0.0f, 0.1f, 0.33f);
            poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)10.0f), 0.0f, 1.0f, 0.0f)));
            poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)(Math.sin((float)(renderState.hammerAngle - 8.0f)) * 30.0f)), 0.0f, 0.0f, 1.0f)));
            poseStack.translate(-0.4f, 0.2f, 0.0f);
            renderState.firstHammerItem.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        if (!renderState.secondHammerItem.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(-0.7f, -0.3f, 0.0f);
            poseStack.translate(0.0f, 0.1f, -0.33f);
            poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)-10.0f), 0.0f, 1.0f, 0.0f)));
            poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)(Math.sin((float)(renderState.hammerAngle + 8.0f)) * 30.0f)), 0.0f, 0.0f, 1.0f)));
            poseStack.translate(-0.4f, 0.2f, 0.0f);
            renderState.secondHammerItem.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
        if (!renderState.item.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate((double)-0.4625f, (double)-0.04f, -0.2);
            poseStack.scale(0.4f, 0.4f, 0.4f);
            renderState.item.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            if (renderState.progress > 0.0f) {
                // empty if block
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public static <T extends AutoHammerBlockEntity> BlockEntityRenderer<T, AutoHammerRenderState> normal(BlockEntityRendererProvider.Context context) {
        return new AutoHammerRenderer(context, false);
    }

    public static <T extends AutoHammerBlockEntity> BlockEntityRenderer<T, AutoHammerRenderState> compressed(BlockEntityRendererProvider.Context context) {
        return new AutoHammerRenderer(context, true);
    }

    public static class AutoHammerRenderState
    extends BlockEntityRenderState {
        public boolean skip;
        public Direction facing = Direction.NORTH;
        public float hammerAngle;
        public final ItemStackRenderState hammerItem = new ItemStackRenderState();
        public final ItemStackRenderState firstHammerItem = new ItemStackRenderState();
        public final ItemStackRenderState secondHammerItem = new ItemStackRenderState();
        public final ItemStackRenderState item = new ItemStackRenderState();
        public float progress;
    }
}

