/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.blay09.mods.excompressum.block.AutoSieveBlock;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.AutoHeavySieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.AutoSieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.SieveAnimationType;
import net.blay09.mods.excompressum.client.ModModels;
import net.blay09.mods.excompressum.client.render.model.TinyHumanModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class AutoSieveRenderer<T extends AbstractAutoSieveBlockEntity>
implements BlockEntityRenderer<T, AutoSieveRenderState> {
    private final BlockRenderDispatcher blockRenderDispatcher;
    private final ItemModelResolver itemModelResolver;
    private final TinyHumanModel tinyHumanModel;
    private final TinyHumanModel tinyHumanModelSlim;
    private final boolean isHeavy;
    public static int cacheKey;
    private int currentCacheKey;
    private BlockStateModel sieveModel;

    public AutoSieveRenderer(BlockEntityRendererProvider.Context context, boolean isHeavy) {
        this.blockRenderDispatcher = context.blockRenderDispatcher();
        this.itemModelResolver = context.itemModelResolver();
        this.tinyHumanModel = new TinyHumanModel(context.bakeLayer(ModelLayers.PLAYER), false);
        this.tinyHumanModelSlim = new TinyHumanModel(context.bakeLayer(ModelLayers.PLAYER_SLIM), true);
        this.isHeavy = isHeavy;
    }

    public void extractRenderState(T blockEntity, AutoSieveRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        if (this.sieveModel == null || this.currentCacheKey != cacheKey) {
            this.sieveModel = this.isHeavy ? this.blockRenderDispatcher.getBlockModel(ModBlocks.heavySieves[0].defaultBlockState()) : (BlockStateModel)ModModels.sieves.get(0).get();
            this.currentCacheKey = cacheKey;
        }
        if (((AbstractAutoSieveBlockEntity)((Object)blockEntity)).shouldAnimate()) {
            float animationSpeed = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getAnimationType() == SieveAnimationType.MAGIC ? 0.05f : 0.5f;
            ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).armAngle += animationSpeed * delta;
            ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).armAngle += animationSpeed * Math.max((float)1.0f, (float)(((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSpeedMultiplier() / 4.0f)) * delta;
        }
        renderState.skip = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).isUgly();
        renderState.progress = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getProgress();
        renderState.meshModelName = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSieveMesh() != null ? ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSieveMesh().getModelName() : null;
        renderState.facing = (Direction)renderState.blockState.getValue((Property)AutoSieveBlock.FACING);
        renderState.waterlogged = (Boolean)renderState.blockState.getValue((Property)AutoSieveBlock.WATERLOGGED);
        renderState.profile = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getSkinProfile();
        renderState.armAngle = ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).armAngle;
        this.itemModelResolver.updateForTopItem(renderState.item, ((AbstractAutoSieveBlockEntity)((Object)blockEntity)).getCurrentStack(), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
    }

    public AutoSieveRenderState createRenderState() {
        return new AutoSieveRenderState();
    }

    public void submit(AutoSieveRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        BlockStateModel meshModel;
        if (renderState.skip) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.mulPose((Quaternionfc)renderState.facing.getRotation());
        poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)-90.0f), 0.0f, 1.0f, 0.0f)));
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)-90.0f), 0.0f, 0.0f, 1.0f)));
        poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)90.0f), 0.0f, 1.0f, 0.0f)));
        poseStack.translate(0.0f, -0.65f, 0.25f);
        poseStack.scale(0.4f, 0.4f, 0.4f);
        PlayerSkin skin = this.getPlayerSkin(renderState.profile);
        TinyHumanModel playerModel = this.getPlayerModel(skin);
        playerModel.animate(renderState);
        submitNodeCollector.submitModel((Model)playerModel, (Object)renderState.avatar, poseStack, RenderType.entityCutout((ResourceLocation)skin.body().texturePath()), renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0, renderState.breakProgress);
        poseStack.popPose();
        if (renderState.waterlogged) {
            poseStack.pushPose();
            poseStack.translate(-0.95f, -0.42f, -0.175f);
            float glassScale = 0.35f;
            poseStack.scale(glassScale, glassScale, glassScale);
            BlockStateModel glassModel = this.blockRenderDispatcher.getBlockModel(Blocks.GLASS.defaultBlockState());
            submitNodeCollector.submitBlockModel(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), glassModel, 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(-0.25f, 0.0f, -0.5f);
        poseStack.mulPose((Quaternionfc)new Quaternionf(new AxisAngle4f(Math.toRadians((float)90.0f), 0.0f, 0.0f, 1.0f)));
        poseStack.translate(-0.2f, -0.1f, 0.0f);
        poseStack.pushPose();
        submitNodeCollector.submitBlockModel(poseStack, RenderType.entitySolid((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), this.sieveModel, 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
        BlockStateModel blockStateModel = meshModel = renderState.meshModelName != null ? (BlockStateModel)ModModels.meshes.get(renderState.meshModelName).get() : null;
        if (meshModel != null) {
            submitNodeCollector.submitBlockModel(poseStack, RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), meshModel, 1.0f, 1.0f, 1.0f, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        }
        if (!renderState.item.isEmpty()) {
            poseStack.pushPose();
            float contentOffset = 0.0625f;
            float meshY = 0.5625f;
            float contentScaleXZ = 0.88f;
            float contentBaseScaleY = 0.5f;
            poseStack.translate(0.0625f, 0.5625f, 0.0625f);
            poseStack.scale(0.88f, 0.5f - renderState.progress * 0.5f, 0.88f);
            renderState.item.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    private PlayerSkin getPlayerSkin(@Nullable ResolvableProfile profile) {
        if (profile != null) {
            return Minecraft.getInstance().playerSkinRenderCache().getOrDefault(profile).playerSkin();
        }
        return DefaultPlayerSkin.get((UUID)UUID.randomUUID());
    }

    private TinyHumanModel getPlayerModel(@Nullable PlayerSkin skin) {
        if (skin != null && "slim".equals(skin.model().getSerializedName())) {
            return this.tinyHumanModelSlim;
        }
        return this.tinyHumanModel;
    }

    public static AutoSieveRenderer<AutoSieveBlockEntity> normal(BlockEntityRendererProvider.Context context) {
        return new AutoSieveRenderer<AutoSieveBlockEntity>(context, false);
    }

    public static AutoSieveRenderer<AutoHeavySieveBlockEntity> heavy(BlockEntityRendererProvider.Context context) {
        return new AutoSieveRenderer<AutoHeavySieveBlockEntity>(context, true);
    }

    public static class AutoSieveRenderState
    extends BlockEntityRenderState {
        public boolean skip;
        public Direction facing = Direction.NORTH;
        public boolean waterlogged;
        @Nullable
        public String meshModelName;
        public final ItemStackRenderState item = new ItemStackRenderState();
        public float progress;
        @Nullable
        public ResolvableProfile profile;
        public SieveAnimationType animationType;
        public float armAngle;
        public final AvatarRenderState avatar = new AvatarRenderState();
    }
}

