/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.blay09.mods.excompressum.block.entity.SieveAnimationType;
import net.blay09.mods.excompressum.client.render.blockentity.AutoSieveRenderer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;

public class TinyHumanModel
extends PlayerModel {
    public TinyHumanModel(ModelPart modelPart, boolean smallArms) {
        super(modelPart, smallArms);
    }

    public void animate(AutoSieveRenderer.AutoSieveRenderState renderState) {
        if (renderState.animationType == SieveAnimationType.MAGIC) {
            float base = (float)Math.toRadians(280.0);
            this.rightArm.xRot = (float)((double)base + Math.sin(renderState.armAngle) * (double)0.1f);
            this.leftArm.xRot = (float)((double)base + Math.cos(renderState.armAngle) * (double)0.1f);
        } else {
            this.rightArm.xRot = renderState.armAngle;
        }
    }

    public void render(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        float scale = 0.0625f;
        poseStack.pushPose();
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.translate(0.0f, 16.0f * scale, 0.0f);
        this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.0f, 24.0f * scale, 0.0f);
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rightArm.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leftArm.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rightLeg.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.leftLeg.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.hat.render(poseStack, buffer, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

