/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import net.blay09.mods.excompressum.loot.LootTableEntry;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.loot.MergedLootTableEntry;
import net.blay09.mods.excompressum.mixin.BinomialDistributionGeneratorAccessor;
import net.blay09.mods.excompressum.mixin.ConstantValueAccessor;
import net.blay09.mods.excompressum.mixin.UniformGeneratorAccessor;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class JeiUtils {
    private static final NumberFormat chanceFormat = new DecimalFormat("##.##");

    public static void addLootTableEntryTooltips(MergedLootTableEntry entry, List<Component> tooltip) {
        LootTableEntry mainEntry = entry.getEntries().get(0);
        tooltip.add((Component)Component.translatable((String)"tooltip.jei.main_roll", (Object[])new Object[]{JeiUtils.getCountTextComponent(mainEntry), JeiUtils.formatChance(mainEntry)}));
        for (int i = 1; i < entry.getEntries().size(); ++i) {
            LootTableEntry bonusEntry = entry.getEntries().get(i);
            tooltip.add((Component)Component.translatable((String)"tooltip.jei.bonus_roll", (Object[])new Object[]{JeiUtils.getCountTextComponent(bonusEntry), JeiUtils.formatChance(bonusEntry)}));
        }
    }

    public static void addLootTableEntryTooltips(LootTableEntry entry, List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"tooltip.jei.main_roll", (Object[])new Object[]{JeiUtils.getCountTextComponent(entry), JeiUtils.formatChance(entry)}));
    }

    private static String formatChance(LootTableEntry entry) {
        return "";
    }

    private static Component getCountTextComponent(LootTableEntry entry) {
        NumberProvider numberProvider = entry.getCountRange();
        if (numberProvider instanceof UniformGeneratorAccessor) {
            UniformGeneratorAccessor uniform = (UniformGeneratorAccessor)numberProvider;
            int min = (int)LootTableUtils.getMinCount(uniform.getMin());
            int max = (int)LootTableUtils.getMaxCount(uniform.getMax());
            return Component.translatable((String)"tooltip.jei.drop_count.random_range", (Object[])new Object[]{min, max});
        }
        NumberProvider min = entry.getCountRange();
        if (min instanceof BinomialDistributionGeneratorAccessor) {
            BinomialDistributionGeneratorAccessor binomial = (BinomialDistributionGeneratorAccessor)min;
            int n = (int)LootTableUtils.getMinCount(binomial.getN());
            int p = (int)LootTableUtils.getMinCount(binomial.getP());
            return Component.translatable((String)"tooltip.jei.drop_count.binomial_range", (Object[])new Object[]{n * p});
        }
        numberProvider = entry.getCountRange();
        if (numberProvider instanceof ConstantValueAccessor) {
            ConstantValueAccessor constant = (ConstantValueAccessor)numberProvider;
            return Component.translatable((String)"tooltip.jei.drop_count.constant", (Object[])new Object[]{(int)constant.getValue()});
        }
        return Component.empty();
    }
}

