/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedWoodenCrucibleRecipe;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class WoodenCrucibleJeiRecipeCategory
implements IRecipeCategory<ExpandedWoodenCrucibleRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"wooden_crucible");
    public static final RecipeType<ExpandedWoodenCrucibleRecipe> TYPE = new RecipeType(UID, ExpandedWoodenCrucibleRecipe.class);
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"textures/gui/jei_wooden_crucible.png");
    private final IDrawable background;
    private final IDrawable icon;

    public WoodenCrucibleJeiRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 0, 166, 129);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.woodenCrucibles[0]));
    }

    public RecipeType<ExpandedWoodenCrucibleRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)UID.toString());
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayoutBuilder, ExpandedWoodenCrucibleRecipe recipe, IFocusGroup focusGroup) {
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 75, 10).addFluidStack(recipe.getFluid(), (long)recipe.getAmount());
        List<ItemStack> inputs = recipe.getInputs();
        for (int i = 0; i < inputs.size(); ++i) {
            int slotX = 3 + i % 9 * 18;
            int slotY = 37 + i / 9 * 18;
            recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).addItemStack(inputs.get(i));
        }
    }

    @Nullable
    public ResourceLocation getRegistryName(ExpandedWoodenCrucibleRecipe recipe) {
        return recipe.getId();
    }
}

