/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.recipeviewers;

import java.util.List;
import java.util.stream.Collectors;
import net.blay09.mods.excompressum.api.recipe.CompressedHammerRecipe;
import net.blay09.mods.excompressum.loot.LootTableEntry;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.loot.MergedLootTableEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ExpandedCompressedHammerRecipe {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final List<MergedLootTableEntry> outputs;
    private final List<ItemStack> outputItems;

    public ExpandedCompressedHammerRecipe(ResourceLocation id, CompressedHammerRecipe recipe) {
        this.id = id;
        this.ingredient = recipe.getIngredient();
        List<LootTableEntry> entries = LootTableUtils.getLootTableEntries(recipe.getLootTable());
        this.outputs = LootTableUtils.mergeLootTableEntries(entries);
        this.outputItems = this.outputs.stream().map(MergedLootTableEntry::getItemStack).collect(Collectors.toList());
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<MergedLootTableEntry> getOutputs() {
        return this.outputs;
    }

    public List<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    public ResourceLocation getId() {
        return this.id;
    }
}

