/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.entity;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AngryChickenEntity
extends PathfinderMob {
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);

    public AngryChickenEntity(EntityType<? extends AngryChickenEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createEntityAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.45);
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void customServerAiStep(ServerLevel serverLevel) {
        super.customServerAiStep(serverLevel);
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return SoundEvents.CHICKEN_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.CHICKEN_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.CHICKEN_HURT;
    }

    public void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        super.playStepSound(pos, state);
        this.playSound(SoundEvents.CHICKEN_STEP, 0.15f, 1.0f);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
    }

    protected void tickDeath() {
        super.tickDeath();
        if (this.deathTime == 18) {
            LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level(), EntitySpawnReason.EVENT);
            if (lightningBolt != null) {
                lightningBolt.setVisualOnly(true);
                lightningBolt.snapTo(Vec3.atBottomCenterOf((Vec3i)this.blockPosition()));
                this.level().addFreshEntity((Entity)lightningBolt);
            }
            Random random = new Random();
            block0: for (int i = 0; i < 3; ++i) {
                int offX = random.nextInt(3) - 2;
                int offZ = random.nextInt(3) - 2;
                for (int y = 0; y <= 1; ++y) {
                    BlockPos pos = this.blockPosition().offset(offX, y, offZ);
                    BlockState state = this.level().getBlockState(pos);
                    if (!state.isAir() && !state.is(BlockTags.REPLACEABLE)) continue;
                    BlockState fireState = BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)pos);
                    this.level().setBlock(pos, fireState, 11);
                    continue block0;
                }
            }
        }
    }

    public void knockback(double strength, double ratioX, double ratioZ) {
        super.knockback(strength * 2.0, ratioX, ratioZ);
    }

    public void tick() {
        super.tick();
        if (this.tickCount < 25) {
            this.refreshDimensions();
        }
    }

    public float getAngryScale() {
        float growProgress = AngryChickenEntity.easeInOutCubic(Math.min(1.0f, (float)(this.tickCount - 5) / 20.0f));
        float maxSize = 1.15f;
        return 1.0f + maxSize * growProgress;
    }

    protected int getBaseExperienceReward(ServerLevel level) {
        return 25;
    }

    private static float easeInOutCubic(float x) {
        return (double)x < 0.5 ? 4.0f * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0);
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        if (!source.isDirect()) {
            Entity arrowEntity = source.getDirectEntity();
            Entity attacker = source.getEntity();
            if (arrowEntity != null && !(attacker instanceof AngryChickenEntity)) {
                level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY() + 1.0, this.getZ(), 50, 0.25, 0.25, 0.25, (double)0.2f);
                if (arrowEntity instanceof Arrow) {
                    Arrow arrow = (Arrow)arrowEntity;
                    if (attacker instanceof LivingEntity) {
                        Arrow reflectedArrow = new Arrow((Level)level, (LivingEntity)this, arrow.getPickupItemStackOrigin(), arrow.getWeaponItem());
                        reflectedArrow.copyPosition(arrowEntity);
                        level.addFreshEntity((Entity)reflectedArrow);
                        double dirX = attacker.getX() - arrowEntity.getX();
                        double dirY = attacker.getY() + (double)1.8f - arrowEntity.getY();
                        double dirZ = attacker.getZ() - arrowEntity.getZ();
                        reflectedArrow.shoot(dirX, dirY, dirZ, 1.0f, 10.0f);
                        arrowEntity.remove(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
            return false;
        }
        return super.hurtServer(level, source, amount);
    }
}

