/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.menu;

import net.blay09.mods.excompressum.block.entity.AutoCompressorBlockEntity;
import net.blay09.mods.excompressum.menu.ModMenus;
import net.blay09.mods.excompressum.menu.OutputSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AutoCompressorMenu
extends AbstractContainerMenu {
    private final AutoCompressorBlockEntity autoCompressor;

    public AutoCompressorMenu(int windowId, Inventory inventoryPlayer, AutoCompressorBlockEntity autoCompressor) {
        super((MenuType)ModMenus.autoCompressor.get(), windowId);
        int j;
        int i;
        this.autoCompressor = autoCompressor;
        Container container = autoCompressor.getBackingContainer();
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                this.addSlot(new Slot(container, i * 3 + j, 8 + j * 18, 8 + i * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                this.addSlot(new OutputSlot(container, 12 + i * 3 + j, 93 + j * 18, 8 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 142));
        }
        this.addDataSlots(autoCompressor.getContainerData());
    }

    public boolean stillValid(Player player) {
        return this.autoCompressor.isUsableByPlayer(player);
    }

    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            itemStack = slotStack.copy();
            if (slotNumber < 24 ? !this.moveItemStackTo(slotStack, 24, 60, true) : this.autoCompressor.getBackingContainer().canPlaceItem(0, slotStack) && !this.moveItemStackTo(slotStack, 0, 12, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return itemStack;
    }

    public AutoCompressorBlockEntity getAutoCompressor() {
        return this.autoCompressor;
    }
}

