/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.neoforge.compat.exdeorum;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.excompressum.api.ExNihiloProvider;
import net.blay09.mods.excompressum.api.recipe.CompressedHammerRecipe;
import net.blay09.mods.excompressum.api.recipe.HammerRecipe;
import net.blay09.mods.excompressum.api.recipe.HeavySieveRecipe;
import net.blay09.mods.excompressum.api.recipe.SieveRecipe;
import net.blay09.mods.excompressum.api.sievemesh.CommonMeshType;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.compressedhammer.CompressedHammerRecipeImpl;
import net.blay09.mods.excompressum.registry.hammer.HammerRecipeImpl;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.exdeorum.recipe.RecipeUtil;
import thedarkcolour.exdeorum.recipe.crook.CrookRecipe;
import thedarkcolour.exdeorum.recipe.sieve.CompressedSieveRecipe;

public class ExDeorumAddon
implements ExNihiloProvider {
    private final Map<Item, CommonMeshType> itemToMeshType = new HashMap<Item, CommonMeshType>();

    public ExDeorumAddon() {
        ItemStack netheriteMeshItem;
        ItemStack diamondMeshItem;
        ItemStack goldMeshItem;
        ItemStack ironMeshItem;
        ItemStack flintMeshItem;
        ExNihilo.setInstance(this);
        ItemStack stringMeshItem = this.findItem("string_mesh");
        if (!stringMeshItem.isEmpty()) {
            SieveMeshRegistryEntry stringMesh = new SieveMeshRegistryEntry(CommonMeshType.STRING, stringMeshItem, stringMeshItem.getItem());
            stringMesh.setModelName("string");
            SieveMeshRegistry.add(stringMesh);
            this.itemToMeshType.put(stringMeshItem.getItem(), CommonMeshType.STRING);
        }
        if (!(flintMeshItem = this.findItem("flint_mesh")).isEmpty()) {
            SieveMeshRegistryEntry flintMesh = new SieveMeshRegistryEntry(CommonMeshType.FLINT, flintMeshItem, flintMeshItem.getItem());
            flintMesh.setModelName("flint");
            SieveMeshRegistry.add(flintMesh);
            this.itemToMeshType.put(flintMeshItem.getItem(), CommonMeshType.FLINT);
        }
        if (!(ironMeshItem = this.findItem("iron_mesh")).isEmpty()) {
            SieveMeshRegistryEntry ironMesh = new SieveMeshRegistryEntry(CommonMeshType.IRON, ironMeshItem, ironMeshItem.getItem());
            ironMesh.setHeavy(true);
            ironMesh.setModelName("iron");
            SieveMeshRegistry.add(ironMesh);
            SieveMeshRegistry.registerDefaults(ironMeshItem.getItem());
            this.itemToMeshType.put(ironMeshItem.getItem(), CommonMeshType.IRON);
        }
        if (!(goldMeshItem = this.findItem("golden_mesh")).isEmpty()) {
            SieveMeshRegistryEntry goldMesh = new SieveMeshRegistryEntry(CommonMeshType.GOLD, goldMeshItem, goldMeshItem.getItem());
            goldMesh.setHeavy(true);
            goldMesh.setModelName("gold");
            SieveMeshRegistry.add(goldMesh);
            this.itemToMeshType.put(goldMeshItem.getItem(), CommonMeshType.GOLD);
        }
        if (!(diamondMeshItem = this.findItem("diamond_mesh")).isEmpty()) {
            SieveMeshRegistryEntry diamondMesh = new SieveMeshRegistryEntry(CommonMeshType.DIAMOND, diamondMeshItem, diamondMeshItem.getItem());
            diamondMesh.setHeavy(true);
            diamondMesh.setModelName("diamond");
            SieveMeshRegistry.add(diamondMesh);
            this.itemToMeshType.put(diamondMeshItem.getItem(), CommonMeshType.DIAMOND);
        }
        if (!(netheriteMeshItem = this.findItem("netherite_mesh")).isEmpty()) {
            SieveMeshRegistryEntry mesh = new SieveMeshRegistryEntry(CommonMeshType.NETHERITE, netheriteMeshItem, netheriteMeshItem.getItem());
            mesh.setHeavy(true);
            mesh.setModelName("netherite");
            SieveMeshRegistry.add(mesh);
            this.itemToMeshType.put(netheriteMeshItem.getItem(), CommonMeshType.NETHERITE);
        }
    }

    private ItemStack findItem(String name) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"exdeorum", (String)name);
        Item item = (Item)BuiltInRegistries.ITEM.getValue(location);
        return new ItemStack((ItemLike)item);
    }

    @Override
    public boolean isHammerable(Level level, BlockState state) {
        return RecipeUtil.getHammerRecipe((Item)StupidUtils.getItemStackFromState(state).getItem()) != null;
    }

    @Override
    public boolean isHammerableCompressed(ItemStack itemStack) {
        return RecipeUtil.getCompressedHammerRecipe((Item)itemStack.getItem()) != null;
    }

    @Override
    public List<ItemStack> rollHammerRewards(Level level, BlockState state, ItemStack toolItem, RandomSource rand) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        thedarkcolour.exdeorum.recipe.hammer.HammerRecipe recipe = RecipeUtil.getHammerRecipe((Item)StupidUtils.getItemStackFromState(state).getItem());
        if (recipe != null) {
            drops.add(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
        }
        return drops;
    }

    @Override
    public boolean isSiftableWithMesh(Level level, BlockState sieveState, BlockState state, @Nullable SieveMeshRegistryEntry sieveMesh) {
        if (sieveMesh == null) {
            return false;
        }
        return !RecipeUtil.getSieveRecipes((Item)((Item)sieveMesh.getBackingMesh()), (ItemStack)StupidUtils.getItemStackFromState(state)).isEmpty();
    }

    @Override
    public boolean isHeavySiftableWithMesh(BlockState sieveState, BlockState state, @Nullable SieveMeshRegistryEntry sieveMesh) {
        if (sieveMesh == null) {
            return false;
        }
        return !RecipeUtil.getCompressedSieveRecipes((Item)((Item)sieveMesh.getBackingMesh()), (ItemStack)StupidUtils.getItemStackFromState(state)).isEmpty();
    }

    @Override
    public Collection<ItemStack> rollSieveRewards(Level level, BlockState sieveState, BlockState state, SieveMeshRegistryEntry sieveMesh, float luck, RandomSource rand) {
        ItemStack sourceStack = StupidUtils.getItemStackFromState(state);
        List recipes = RecipeUtil.getSieveRecipes((Item)((Item)sieveMesh.getBackingMesh()), (ItemStack)sourceStack);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (thedarkcolour.exdeorum.recipe.sieve.SieveRecipe recipe : recipes) {
            LootContext lootContext = LootTableUtils.buildLootContext((ServerLevel)level, sourceStack);
            int amount = recipe.resultAmount.getInt(lootContext);
            if (amount <= 0) continue;
            list.add(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
        }
        return list;
    }

    @Override
    public Collection<ItemStack> rollHeavySieveRewards(Level level, BlockState sieveState, BlockState state, SieveMeshRegistryEntry sieveMesh, float luck, RandomSource rand) {
        ItemStack sourceStack = StupidUtils.getItemStackFromState(state);
        List recipes = RecipeUtil.getCompressedSieveRecipes((Item)((Item)sieveMesh.getBackingMesh()), (ItemStack)sourceStack);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (CompressedSieveRecipe recipe : recipes) {
            LootContext lootContext = LootTableUtils.buildLootContext((ServerLevel)level, sourceStack);
            int amount = recipe.resultAmount.getInt(lootContext);
            if (amount <= 0) continue;
            list.add(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
        }
        return list;
    }

    @Override
    public Collection<ItemStack> rollCompressedHammerRewards(Level level, LootContext context, ItemStack itemStack) {
        thedarkcolour.exdeorum.recipe.hammer.CompressedHammerRecipe recipe = RecipeUtil.getCompressedHammerRecipe((Item)itemStack.getItem());
        if (recipe != null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            LootContext lootContext = LootTableUtils.buildLootContext((ServerLevel)level, itemStack);
            int amount = recipe.resultAmount.getInt(lootContext);
            if (amount > 0) {
                list.add(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<ItemStack> rollCrookRewards(ServerLevel level, BlockPos pos, BlockState state, @Nullable Entity entity, ItemStack tool, RandomSource rand) {
        float fortune = this.getLuckFromTool((Level)level, tool);
        List recipes = RecipeUtil.getCrookRecipes((BlockState)state);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (CrookRecipe recipe : recipes) {
            int rolls = Math.max(1, Mth.ceil((float)(fortune / 3.0f)));
            for (int i = 0; i < rolls; ++i) {
                if (!(rand.nextFloat() < recipe.chance())) continue;
                list.add(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
            }
        }
        return list;
    }

    private float getLuckFromTool(Level level, ItemStack tool) {
        Holder.Reference fortuneEnchantment = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)fortuneEnchantment, (ItemStack)tool);
    }

    @Override
    public LootTable generateHeavySieveLootTable(Level level, BlockState sieveState, ItemLike source, int times, SieveMeshRegistryEntry mesh) {
        return LootTable.EMPTY;
    }

    @Override
    public boolean doMeshesHaveDurability() {
        return false;
    }

    @Override
    public int getMeshFortune(ItemStack meshStack) {
        return 0;
    }

    @Override
    public int getMeshEfficiency(ItemStack meshStack) {
        return 0;
    }

    @Override
    public boolean isCompressableOre(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isHammerableOre(ItemStack itemStack) {
        return false;
    }

    @Override
    public List<HammerRecipe> getHammerRecipes() {
        ArrayList<HammerRecipe> result = new ArrayList<HammerRecipe>();
        ArrayListMultimap groupedRecipes = ArrayListMultimap.create();
        for (RecipeHolder hammerRecipe : RecipeUtil.getCachedHammerRecipes()) {
            groupedRecipes.put((Object)((thedarkcolour.exdeorum.recipe.hammer.HammerRecipe)hammerRecipe.value()).ingredient().getValues(), (Object)((thedarkcolour.exdeorum.recipe.hammer.HammerRecipe)hammerRecipe.value()));
        }
        for (HolderSet packedStacks : groupedRecipes.keySet()) {
            LootTable.Builder tableBuilder = LootTable.lootTable();
            for (thedarkcolour.exdeorum.recipe.hammer.HammerRecipe hammerRecipe : groupedRecipes.get((Object)packedStacks)) {
                LootPool.Builder poolBuilder = LootPool.lootPool();
                LootPoolSingletonContainer.Builder<?> entryBuilder = this.buildLootEntry(hammerRecipe.result(), hammerRecipe.resultAmount);
                poolBuilder.add(entryBuilder);
                tableBuilder.withPool(poolBuilder);
            }
            thedarkcolour.exdeorum.recipe.hammer.HammerRecipe firstRecipe = (thedarkcolour.exdeorum.recipe.hammer.HammerRecipe)groupedRecipes.get((Object)packedStacks).getFirst();
            Ingredient input = firstRecipe.ingredient();
            LootTable lootTableProvider = tableBuilder.build();
            result.add(new HammerRecipeImpl(input, lootTableProvider));
        }
        return result;
    }

    private LootPoolSingletonContainer.Builder<?> buildLootEntry(ItemStack itemStack, NumberProvider amount) {
        return LootTableUtils.buildLootEntry(itemStack, amount);
    }

    @Override
    public List<CompressedHammerRecipe> getCompressedHammerRecipes() {
        ArrayList<CompressedHammerRecipe> result = new ArrayList<CompressedHammerRecipe>();
        ArrayListMultimap groupedRecipes = ArrayListMultimap.create();
        for (RecipeHolder hammerRecipe : RecipeUtil.getCachedCompressedHammerRecipes()) {
            groupedRecipes.put((Object)((thedarkcolour.exdeorum.recipe.hammer.CompressedHammerRecipe)hammerRecipe.value()).ingredient().getValues(), (Object)((thedarkcolour.exdeorum.recipe.hammer.CompressedHammerRecipe)hammerRecipe.value()));
        }
        for (HolderSet packedStacks : groupedRecipes.keySet()) {
            LootTable.Builder tableBuilder = LootTable.lootTable();
            for (thedarkcolour.exdeorum.recipe.hammer.CompressedHammerRecipe hammerRecipe : groupedRecipes.get((Object)packedStacks)) {
                LootPool.Builder poolBuilder = LootPool.lootPool();
                LootPoolSingletonContainer.Builder<?> entryBuilder = this.buildLootEntry(hammerRecipe.result(), hammerRecipe.resultAmount);
                poolBuilder.add(entryBuilder);
                tableBuilder.withPool(poolBuilder);
            }
            thedarkcolour.exdeorum.recipe.hammer.CompressedHammerRecipe firstRecipe = (thedarkcolour.exdeorum.recipe.hammer.CompressedHammerRecipe)groupedRecipes.get((Object)packedStacks).getFirst();
            Ingredient input = firstRecipe.ingredient();
            LootTable lootTableProvider = tableBuilder.build();
            result.add(new CompressedHammerRecipeImpl(input, lootTableProvider));
        }
        return result;
    }

    @Override
    public List<SieveRecipe> getSieveRecipes() {
        ArrayList<SieveRecipe> result = new ArrayList<SieveRecipe>();
        return result;
    }

    @Override
    public List<HeavySieveRecipe> getHeavySieveRecipes() {
        ArrayList<HeavySieveRecipe> result = new ArrayList<HeavySieveRecipe>();
        return result;
    }
}

