/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.neoforge.compat.exnihilosequentia;

import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.excompressum.api.ExNihiloProvider;
import net.blay09.mods.excompressum.api.recipe.CompressedHammerRecipe;
import net.blay09.mods.excompressum.api.recipe.HammerRecipe;
import net.blay09.mods.excompressum.api.recipe.HeavySieveRecipe;
import net.blay09.mods.excompressum.api.recipe.SieveRecipe;
import net.blay09.mods.excompressum.api.sievemesh.CommonMeshType;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.hammer.HammerRecipeImpl;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import novamachina.exnihilosequentia.common.Config;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.world.item.MeshType;
import novamachina.exnihilosequentia.world.item.crafting.CrushingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.HarvestRecipe;
import novamachina.exnihilosequentia.world.item.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.world.item.crafting.MeshWithChance;
import novamachina.exnihilosequentia.world.item.crafting.SiftingRecipe;
import novamachina.exnihilosequentia.world.level.block.InfestedLeavesBlock;
import org.jetbrains.annotations.Nullable;

public class ExNihiloSequentiaAddon
implements ExNihiloProvider {
    public ExNihiloSequentiaAddon() {
        ItemStack netheriteMeshItem;
        ItemStack emeraldMeshItem;
        ItemStack diamondMeshItem;
        ItemStack ironMeshItem;
        ItemStack flintMeshItem;
        ExNihilo.setInstance(this);
        SieveMeshRegistry.registerDefaults(MeshType.IRON);
        ItemStack stringMeshItem = this.findItem("string_mesh");
        if (!stringMeshItem.isEmpty()) {
            SieveMeshRegistryEntry stringMesh = new SieveMeshRegistryEntry(CommonMeshType.STRING, stringMeshItem, MeshType.STRING);
            stringMesh.setModelName("string");
            SieveMeshRegistry.add(stringMesh);
        }
        if (!(flintMeshItem = this.findItem("flint_mesh")).isEmpty()) {
            SieveMeshRegistryEntry flintMesh = new SieveMeshRegistryEntry(CommonMeshType.FLINT, flintMeshItem, MeshType.FLINT);
            flintMesh.setModelName("flint");
            SieveMeshRegistry.add(flintMesh);
        }
        if (!(ironMeshItem = this.findItem("iron_mesh")).isEmpty()) {
            SieveMeshRegistryEntry ironMesh = new SieveMeshRegistryEntry(CommonMeshType.IRON, ironMeshItem, MeshType.IRON);
            ironMesh.setHeavy(true);
            ironMesh.setModelName("iron");
            SieveMeshRegistry.add(ironMesh);
        }
        if (!(diamondMeshItem = this.findItem("diamond_mesh")).isEmpty()) {
            SieveMeshRegistryEntry diamondMesh = new SieveMeshRegistryEntry(CommonMeshType.DIAMOND, diamondMeshItem, MeshType.DIAMOND);
            diamondMesh.setHeavy(true);
            diamondMesh.setModelName("diamond");
            SieveMeshRegistry.add(diamondMesh);
        }
        if (!(emeraldMeshItem = this.findItem("emerald_mesh")).isEmpty()) {
            SieveMeshRegistryEntry emeraldMesh = new SieveMeshRegistryEntry(CommonMeshType.EMERALD, emeraldMeshItem, MeshType.EMERALD);
            emeraldMesh.setHeavy(true);
            emeraldMesh.setModelName("emerald");
            SieveMeshRegistry.add(emeraldMesh);
        }
        if (!(netheriteMeshItem = this.findItem("netherite_mesh")).isEmpty()) {
            SieveMeshRegistryEntry mesh = new SieveMeshRegistryEntry(CommonMeshType.NETHERITE, netheriteMeshItem, MeshType.NETHERITE);
            mesh.setHeavy(true);
            mesh.setModelName("netherite");
            SieveMeshRegistry.add(mesh);
        }
    }

    private ItemStack findItem(String name) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"exnihilosequentia", (String)name);
        Item item = (Item)BuiltInRegistries.ITEM.getValue(location);
        return new ItemStack((ItemLike)item);
    }

    @Override
    public boolean isHammerableCompressed(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isHammerable(Level level, BlockState state) {
        return ExNihiloRegistries.HAMMER_REGISTRY.isHammerable(state.getBlock());
    }

    @Override
    public List<ItemStack> rollHammerRewards(Level level, BlockState state, ItemStack toolItem, RandomSource rand) {
        List possibleDrops = ExNihiloRegistries.HAMMER_REGISTRY.getResult(state.getBlock());
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (ItemStackWithChance itemStackWithChance : possibleDrops) {
            if (!(rand.nextFloat() <= itemStackWithChance.getChance())) continue;
            drops.add(itemStackWithChance.getStack().copy());
        }
        return drops;
    }

    @Override
    public boolean isSiftableWithMesh(Level level, BlockState sieveState, BlockState state, SieveMeshRegistryEntry sieveMesh) {
        if (state.isEmpty()) {
            return false;
        }
        boolean waterlogged = sieveState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)sieveState.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        MeshType mesh = sieveMesh != null ? (MeshType)sieveMesh.getBackingMesh() : MeshType.NONE;
        return ExNihiloRegistries.SIEVE_REGISTRY.isBlockSiftable(state.getBlock(), mesh, waterlogged);
    }

    @Override
    public Collection<ItemStack> rollSieveRewards(Level level, BlockState sieveState, BlockState state, SieveMeshRegistryEntry sieveMesh, float luck, RandomSource rand) {
        boolean waterlogged = sieveState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)sieveState.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        List recipes = ExNihiloRegistries.SIEVE_REGISTRY.getDrops((ItemLike)state.getBlock(), (MeshType)sieveMesh.getBackingMesh(), waterlogged);
        if (recipes != null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (SiftingRecipe recipe : recipes) {
                int tries = rand.nextInt((int)luck + 1) + 1;
                for (int i = 0; i < tries; ++i) {
                    for (MeshWithChance roll : recipe.getRolls()) {
                        if (!(rand.nextDouble() < (double)roll.getChance())) continue;
                        ItemStack itemStack = recipe.getDrop();
                        list.add(itemStack.copy());
                    }
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ItemStack> rollHeavySieveRewards(Level level, BlockState sieveState, BlockState state, SieveMeshRegistryEntry sieveMesh, float luck, RandomSource rand) {
        return Collections.emptyList();
    }

    @Override
    public Collection<ItemStack> rollCompressedHammerRewards(Level level, LootContext context, ItemStack itemStack) {
        return Collections.emptyList();
    }

    @Override
    public List<ItemStack> rollCrookRewards(ServerLevel level, BlockPos pos, BlockState state, @Nullable Entity entity, ItemStack tool, RandomSource rand) {
        float luck = this.getLuckFromTool((Level)level, tool);
        if (state.getBlock() instanceof InfestedLeavesBlock) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(new ItemStack((ItemLike)Items.STRING, rand.nextInt(Config.getMaxBonusStringCount()) + Config.getMinStringCount()));
            if (rand.nextDouble() <= 0.8) {
                // empty if block
            }
            return list;
        }
        if (!state.is(BlockTags.LEAVES)) {
            return Collections.emptyList();
        }
        List recipes = ExNihiloRegistries.CROOK_REGISTRY.getDrops((ItemLike)state.getBlock());
        if (recipes != null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < Config.getVanillaSimulateDropCount(); ++i) {
                List items = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, null);
                list.addAll(items);
            }
            for (HarvestRecipe recipe : recipes) {
                for (ItemStackWithChance drop : recipe.getDrops()) {
                    float fortuneChanceBonus = 0.1f;
                    if (!(rand.nextFloat() <= drop.getChance() + fortuneChanceBonus * luck)) continue;
                    list.add(drop.getStack().copy());
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    private float getLuckFromTool(Level level, ItemStack tool) {
        Holder.Reference fortuneEnchantment = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
        return EnchantmentHelper.getItemEnchantmentLevel((Holder)fortuneEnchantment, (ItemStack)tool);
    }

    @Override
    public LootTable generateHeavySieveLootTable(Level level, BlockState sieveState, ItemLike source, int times, SieveMeshRegistryEntry mesh) {
        if (!(mesh.getBackingMesh() instanceof MeshType)) {
            return LootTable.EMPTY;
        }
        boolean waterlogged = sieveState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)sieveState.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        LootTable.Builder tableBuilder = LootTable.lootTable();
        List recipes = ExNihiloRegistries.SIEVE_REGISTRY.getDrops(source, (MeshType)mesh.getBackingMesh(), waterlogged);
        for (SiftingRecipe recipe : recipes) {
            ItemStack itemStack = recipe.getDrop();
            for (MeshWithChance roll : recipe.getRolls()) {
                LootPool.Builder poolBuilder = LootPool.lootPool();
                poolBuilder.name("excompressum-heavysieve-" + BuiltInRegistries.ITEM.getKey((Object)source.asItem()).toString().replace(':', '-') + "-" + String.valueOf(UUID.randomUUID()));
                poolBuilder.setRolls((NumberProvider)ConstantValue.exactly((float)times));
                LootPoolSingletonContainer.Builder<?> entryBuilder = this.buildLootEntry(itemStack);
                entryBuilder.when(LootItemRandomChanceCondition.randomChance((float)roll.getChance()));
                poolBuilder.add(entryBuilder);
                tableBuilder.withPool(poolBuilder);
            }
        }
        return tableBuilder.build();
    }

    @Override
    public boolean doMeshesHaveDurability() {
        return false;
    }

    @Override
    public int getMeshFortune(ItemStack meshStack) {
        return 0;
    }

    @Override
    public int getMeshEfficiency(ItemStack meshStack) {
        return 0;
    }

    @Override
    public boolean isCompressableOre(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean isHammerableOre(ItemStack itemStack) {
        return false;
    }

    @Override
    public List<HammerRecipe> getHammerRecipes() {
        ArrayListMultimap groupedRecipes = ArrayListMultimap.create();
        for (CrushingRecipe hammerRecipe : ExNihiloRegistries.HAMMER_REGISTRY.getRecipeList()) {
            groupedRecipes.put((Object)hammerRecipe.getInput().getValues(), (Object)hammerRecipe);
        }
        ArrayList<HammerRecipe> result = new ArrayList<HammerRecipe>();
        for (HolderSet packedStacks : groupedRecipes.keySet()) {
            LootTable.Builder tableBuilder = LootTable.lootTable();
            for (CrushingRecipe hammerRecipe : groupedRecipes.get((Object)packedStacks)) {
                for (ItemStackWithChance itemStackWithChance : hammerRecipe.getDrops()) {
                    LootPool.Builder poolBuilder = LootPool.lootPool();
                    LootPoolSingletonContainer.Builder<?> entryBuilder = this.buildLootEntry(itemStackWithChance);
                    poolBuilder.add(entryBuilder);
                    tableBuilder.withPool(poolBuilder);
                }
            }
            CrushingRecipe firstRecipe = (CrushingRecipe)groupedRecipes.get((Object)packedStacks).get(0);
            Ingredient input = firstRecipe.getInput();
            LootTable lootTable = tableBuilder.build();
            result.add(new HammerRecipeImpl(input, lootTable));
        }
        return result;
    }

    private LootPoolSingletonContainer.Builder<?> buildLootEntry(ItemStack outputItem) {
        return LootTableUtils.buildLootEntry(outputItem, -1.0f);
    }

    private LootPoolSingletonContainer.Builder<?> buildLootEntry(ItemStackWithChance outputItem) {
        return LootTableUtils.buildLootEntry(outputItem.getStack(), outputItem.getChance());
    }

    @Override
    public boolean isHeavySiftableWithMesh(BlockState sieveState, BlockState state, @Nullable SieveMeshRegistryEntry sieveMesh) {
        return false;
    }

    @Override
    public List<CompressedHammerRecipe> getCompressedHammerRecipes() {
        return List.of();
    }

    @Override
    public List<SieveRecipe> getSieveRecipes() {
        return List.of();
    }

    @Override
    public List<HeavySieveRecipe> getHeavySieveRecipes() {
        return List.of();
    }
}

