/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.compressor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.blay09.mods.excompressum.mixin.RecipeManagerAccessor;
import net.blay09.mods.excompressum.mixin.ShapedRecipeAccessor;
import net.blay09.mods.excompressum.mixin.ShapelessRecipeAccessor;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.Nullable;

public class CompressedRecipeRegistry {
    private final Map<ResourceLocation, CompressedRecipe> recipesById = new HashMap<ResourceLocation, CompressedRecipe>();
    private final List<CompressedRecipe> recipesSmall = new ArrayList<CompressedRecipe>();
    private final List<CompressedRecipe> recipes = new ArrayList<CompressedRecipe>();
    private final Map<ResourceLocation, CompressedRecipe> cacheByItemId = new HashMap<ResourceLocation, CompressedRecipe>();

    public void reloadRecipes(RecipeManager recipeManager, RegistryAccess registryAccess) {
        this.recipesById.clear();
        this.cacheByItemId.clear();
        this.recipesSmall.clear();
        this.recipes.clear();
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        for (RecipeHolder recipeHolder : recipeMap.byType(RecipeType.CRAFTING)) {
            ShapelessRecipe shapelessRecipe;
            boolean passesInner;
            int count;
            List<Ingredient> ingredients;
            CraftingRecipe recipe = (CraftingRecipe)recipeHolder.value();
            if (recipe instanceof ShapedRecipe) {
                Optional optionalFirst;
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                ingredients = shapedRecipe.getIngredients();
                count = ingredients.size();
                if (count != 4 && count != 9 || (optionalFirst = (Optional)ingredients.getFirst()).isEmpty()) continue;
                Ingredient first = (Ingredient)optionalFirst.get();
                boolean passes = true;
                for (int i = 1; i < count; ++i) {
                    passesInner = false;
                    Optional optionalOther = (Optional)ingredients.get(i);
                    if (optionalOther.isPresent()) {
                        Ingredient other = (Ingredient)optionalOther.get();
                        List items = other.items().toList();
                        for (Holder itemHolder : items) {
                            if (!first.test(new ItemStack(itemHolder))) continue;
                            passesInner = true;
                            break;
                        }
                    }
                    if (passesInner) continue;
                    passes = false;
                    break;
                }
                ItemStack result = ((ShapedRecipeAccessor)shapedRecipe).getResult();
                if (count == 4 && shapedRecipe.getWidth() == 2 && shapedRecipe.getHeight() == 2) {
                    if (!passes) continue;
                    this.recipesSmall.add(new CompressedRecipe(recipeHolder.id().location(), first, 4, result.copy()));
                    continue;
                }
                if (count != 9 || shapedRecipe.getWidth() != 3 || shapedRecipe.getHeight() != 3 || !passes) continue;
                this.recipes.add(new CompressedRecipe(recipeHolder.id().location(), first, 9, result.copy()));
                continue;
            }
            if (!(recipe instanceof ShapelessRecipe) || (count = (ingredients = ((ShapelessRecipeAccessor)(shapelessRecipe = (ShapelessRecipe)recipe)).getIngredients()).size()) != 4 && count != 9) continue;
            Ingredient first = ingredients.getFirst();
            boolean passes = true;
            for (int i = 1; i < count; ++i) {
                Ingredient other = ingredients.get(i);
                passesInner = false;
                List items = other.items().toList();
                for (Holder itemHolder : items) {
                    if (!first.test(new ItemStack(itemHolder))) continue;
                    passesInner = true;
                    break;
                }
                if (passesInner) continue;
                passes = false;
                break;
            }
            ItemStack result = ((ShapelessRecipeAccessor)shapelessRecipe).getResult();
            if (count == 4) {
                if (!passes) continue;
                this.recipesSmall.add(new CompressedRecipe(recipeHolder.id().location(), first, 4, result.copy()));
                continue;
            }
            if (!passes) continue;
            this.recipes.add(new CompressedRecipe(recipeHolder.id().location(), first, 9, result.copy()));
        }
    }

    @Nullable
    public CompressedRecipe getRecipe(ItemStack itemStack) {
        if (!itemStack.getComponentsPatch().isEmpty()) {
            return null;
        }
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        CompressedRecipe foundRecipe = this.cacheByItemId.get(registryName);
        if (foundRecipe != null) {
            return foundRecipe;
        }
        for (CompressedRecipe recipe : this.recipes) {
            if (!recipe.ingredient().test(itemStack)) continue;
            this.cacheByItemId.put(registryName, recipe);
            return recipe;
        }
        for (CompressedRecipe recipe : this.recipesSmall) {
            if (!recipe.ingredient().test(itemStack)) continue;
            this.cacheByItemId.put(registryName, recipe);
            return recipe;
        }
        this.cacheByItemId.put(registryName, null);
        return null;
    }

    public CompressedRecipe getRecipeById(ResourceLocation id) {
        return this.recipesById.get(id);
    }
}

