/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.hammer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.excompressum.api.recipe.HammerRecipe;
import net.blay09.mods.excompressum.registry.ExCompressumRecipe;
import net.blay09.mods.excompressum.registry.ExCompressumSerializers;
import net.blay09.mods.excompressum.registry.ModRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.storage.loot.LootTable;

public class HammerRecipeImpl
extends ExCompressumRecipe<RecipeInput>
implements HammerRecipe {
    private final Ingredient ingredient;
    private final LootTable lootTable;

    public HammerRecipeImpl(Ingredient ingredient, LootTable lootTable) {
        this.ingredient = ingredient;
        this.lootTable = lootTable;
    }

    public RecipeSerializer<HammerRecipeImpl> getSerializer() {
        return ModRecipeTypes.hammerRecipeSerializer;
    }

    public RecipeType<HammerRecipeImpl> getType() {
        return ModRecipeTypes.hammerRecipeType;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create((Ingredient)this.ingredient);
    }

    public RecipeBookCategory recipeBookCategory() {
        return ModRecipeTypes.hammerRecipeBookCategory;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public LootTable getLootTable() {
        return this.lootTable;
    }

    public static class Serializer
    implements RecipeSerializer<HammerRecipeImpl> {
        private static final MapCodec<HammerRecipeImpl> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(recipe -> recipe.ingredient), (App)LootTable.DIRECT_CODEC.fieldOf("lootTable").forGetter(recipe -> recipe.lootTable)).apply((Applicative)instance, HammerRecipeImpl::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, HammerRecipeImpl> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, HammerRecipeImpl::getIngredient, ExCompressumSerializers.LOOT_TABLE_STREAM_CODEC, HammerRecipeImpl::getLootTable, HammerRecipeImpl::new);

        public MapCodec<HammerRecipeImpl> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HammerRecipeImpl> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

