/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.hammer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.excompressum.api.recipe.HammerRecipe;
import net.blay09.mods.excompressum.mixin.RecipeManagerAccessor;
import net.blay09.mods.excompressum.registry.ModRecipeTypes;
import net.blay09.mods.excompressum.registry.hammer.HammerRecipeImpl;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class HammerRegistry {
    public static List<ItemStack> rollHammerRewards(LootContext context, ItemStack itemStack) {
        RecipeManager recipeManager = context.getLevel().getServer().getRecipeManager();
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.hammerRecipeType);
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (RecipeHolder recipeHolder : recipes) {
            LootTable lootTable;
            HammerRecipeImpl recipe = (HammerRecipeImpl)recipeHolder.value();
            if (!HammerRegistry.testRecipe(itemStack, recipe) || (lootTable = recipe.getLootTable()) == null) continue;
            lootTable.getRandomItems(context, results::add);
        }
        return results;
    }

    private static boolean testRecipe(ItemStack itemStack, HammerRecipe recipe) {
        return recipe.getIngredient().test(itemStack);
    }

    public boolean isHammerable(ServerLevel level, ItemStack itemStack) {
        return this.isHammerable(level.getServer().getRecipeManager(), itemStack);
    }

    public boolean isHammerable(RecipeManager recipeManager, ItemStack itemStack) {
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.hammerRecipeType);
        for (RecipeHolder recipeHolder : recipes) {
            if (!HammerRegistry.testRecipe(itemStack, (HammerRecipe)recipeHolder.value())) continue;
            return true;
        }
        return false;
    }
}

