/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.heavysieve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.excompressum.api.recipe.HeavySieveRecipe;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.mixin.RecipeManagerAccessor;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ModRecipeTypes;
import net.blay09.mods.excompressum.registry.heavysieve.GeneratedHeavySieveRecipe;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRecipeImpl;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

public class HeavySieveRegistry {
    private static boolean testRecipe(SieveMeshRegistryEntry mesh, ItemStack itemStack, boolean waterlogged, HeavySieveRecipe recipe) {
        if (recipe.isWaterlogged() != waterlogged) {
            return false;
        }
        if (!recipe.getMeshes().isEmpty() && !recipe.getMeshes().contains((Object)mesh.getMeshType())) {
            return false;
        }
        return recipe.getIngredient().test(itemStack);
    }

    private static boolean testGeneratedRecipe(Level level, ItemStack itemStack, GeneratedHeavySieveRecipe generatedRecipe, BlockState sieve, SieveMeshRegistryEntry sieveMesh) {
        Block sourceBlock = (Block)BuiltInRegistries.BLOCK.getValue(generatedRecipe.getSourceItem());
        return generatedRecipe.getIngredient().test(itemStack) && ExNihilo.isSiftableWithMesh(level, sieve, new ItemStack((ItemLike)sourceBlock), sieveMesh);
    }

    public static List<ItemStack> rollSieveRewards(Level level, LootContext context, BlockState sieve, SieveMeshRegistryEntry mesh, ItemStack itemStack) {
        boolean waterlogged = sieve.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)sieve.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        RecipeManager recipeManager = context.getLevel().getServer().getRecipeManager();
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.heavySieveRecipeType);
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (Object recipeHolder : recipes) {
            LootTable lootTable;
            HeavySieveRecipeImpl recipe = (HeavySieveRecipeImpl)recipeHolder.value();
            if (!HeavySieveRegistry.testRecipe(mesh, itemStack, waterlogged, recipe) || (lootTable = recipe.getLootTable()) == null) continue;
            lootTable.getRandomItems(context, results::add);
        }
        Collection generatedRecipes = recipeMap.byType(ModRecipeTypes.generatedHeavySieveRecipeType);
        for (RecipeHolder recipeHolder : generatedRecipes) {
            GeneratedHeavySieveRecipe recipe = (GeneratedHeavySieveRecipe)recipeHolder.value();
            if (!HeavySieveRegistry.testGeneratedRecipe(level, itemStack, recipe, sieve, mesh)) continue;
            int rolls = HeavySieveRegistry.getGeneratedRollCount(recipe);
            ItemLike source = (ItemLike)BuiltInRegistries.ITEM.getValue(recipe.getSourceItem());
            LootTable lootTable = ExNihilo.getInstance().generateHeavySieveLootTable(level, sieve, source, rolls, mesh);
            if (lootTable == null) continue;
            lootTable.getRandomItems(context, results::add);
        }
        BlockState inputState = StupidUtils.getStateFromItemStack(itemStack);
        results.addAll(ExNihilo.getInstance().rollHeavySieveRewards(level, sieve, inputState, mesh, context.getLuck(), level.random));
        return results;
    }

    public static Integer getGeneratedRollCount(GeneratedHeavySieveRecipe generatedRecipe) {
        return generatedRecipe.getRolls() > 0 ? generatedRecipe.getRolls() : ExCompressumConfig.getActive().general.heavySieveDefaultRolls;
    }

    public boolean isSiftable(ServerLevel level, BlockState sieve, ItemStack itemStack, SieveMeshRegistryEntry sieveMesh) {
        boolean waterlogged = sieve.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)sieve.getValue((Property)BlockStateProperties.WATERLOGGED) != false;
        RecipeManager recipeManager = level.getServer().getRecipeManager();
        RecipeMap recipeMap = ((RecipeManagerAccessor)recipeManager).getRecipes();
        Collection recipes = recipeMap.byType(ModRecipeTypes.heavySieveRecipeType);
        for (Object recipeHolder : recipes) {
            HeavySieveRecipeImpl recipe = (HeavySieveRecipeImpl)recipeHolder.value();
            if (!HeavySieveRegistry.testRecipe(sieveMesh, itemStack, waterlogged, recipe)) continue;
            return true;
        }
        Collection generatedRecipes = recipeMap.byType(ModRecipeTypes.generatedHeavySieveRecipeType);
        for (RecipeHolder recipeHolder : generatedRecipes) {
            GeneratedHeavySieveRecipe recipe = (GeneratedHeavySieveRecipe)recipeHolder.value();
            if (!HeavySieveRegistry.testGeneratedRecipe((Level)level, itemStack, recipe, sieve, sieveMesh)) continue;
            return true;
        }
        BlockState state = StupidUtils.getStateFromItemStack(itemStack);
        return ExNihilo.getInstance().isHeavySiftableWithMesh(sieve, state, sieveMesh);
    }
}

