/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.sievemesh;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.excompressum.api.sievemesh.CommonMeshType;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SieveMeshRegistry {
    private static final Map<CommonMeshType, SieveMeshRegistryEntry> entriesByType = new HashMap<CommonMeshType, SieveMeshRegistryEntry>();
    private static final Map<ResourceLocation, SieveMeshRegistryEntry> entriesByItem = new HashMap<ResourceLocation, SieveMeshRegistryEntry>();

    public static void registerDefaults(@Nullable Object backingMesh) {
        SieveMeshRegistryEntry ironMesh = new SieveMeshRegistryEntry(CommonMeshType.IRON, new ItemStack((ItemLike)ModItems.ironMesh), backingMesh);
        ironMesh.setHeavy(true);
        ironMesh.setModelName("iron");
        SieveMeshRegistry.add(ironMesh);
    }

    public static Map<ResourceLocation, SieveMeshRegistryEntry> getEntries() {
        return entriesByItem;
    }

    @Nullable
    public static SieveMeshRegistryEntry getEntry(ItemStack itemStack) {
        ExNihilo.getInstance();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        return entriesByItem.get(itemId);
    }

    public static void add(SieveMeshRegistryEntry sieveMesh) {
        entriesByType.put(sieveMesh.getMeshType(), sieveMesh);
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)sieveMesh.getItemStack().getItem());
        entriesByItem.put(itemId, sieveMesh);
    }

    public static SieveMeshRegistryEntry getEntry(CommonMeshType type) {
        return entriesByType.get((Object)type);
    }
}

