/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.woodencrucible;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.blay09.mods.excompressum.registry.ExCompressumRecipe;
import net.blay09.mods.excompressum.registry.ModRecipeTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;

public class WoodenCrucibleRecipe
extends ExCompressumRecipe<RecipeInput> {
    private final Ingredient ingredient;
    private final ResourceLocation fluid;
    private final int amount;

    public WoodenCrucibleRecipe(Ingredient ingredient, ResourceLocation fluid, Integer amount) {
        this.ingredient = ingredient;
        this.fluid = fluid;
        this.amount = amount;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ResourceLocation getFluidId() {
        return this.fluid;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public RecipeSerializer<WoodenCrucibleRecipe> getSerializer() {
        return ModRecipeTypes.woodenCrucibleRecipeSerializer;
    }

    public RecipeType<WoodenCrucibleRecipe> getType() {
        return ModRecipeTypes.woodenCrucibleRecipeType;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create((Ingredient)this.ingredient);
    }

    public RecipeBookCategory recipeBookCategory() {
        return ModRecipeTypes.woodenCrucibleRecipeBookCategory;
    }

    public boolean matchesFluid(Fluid fluid) {
        ResourceLocation fluidId = BuiltInRegistries.FLUID.getKey((Object)fluid);
        return Objects.equals(fluidId, this.fluid);
    }

    public Fluid getFluid() {
        return (Fluid)BuiltInRegistries.FLUID.getValue(this.fluid);
    }

    public static class Serializer
    implements RecipeSerializer<WoodenCrucibleRecipe> {
        private static final MapCodec<WoodenCrucibleRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("input").forGetter(recipe -> recipe.ingredient), (App)ResourceLocation.CODEC.fieldOf("fluid").forGetter(recipe -> recipe.fluid), (App)Codec.INT.fieldOf("amount").forGetter(recipe -> recipe.amount)).apply((Applicative)instance, WoodenCrucibleRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WoodenCrucibleRecipe> STREAM_CODEC = StreamCodec.of(Serializer::encode, Serializer::decode);

        public MapCodec<WoodenCrucibleRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WoodenCrucibleRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static WoodenCrucibleRecipe decode(RegistryFriendlyByteBuf buf) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ResourceLocation fluidId = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf);
            Integer amount = (Integer)ByteBufCodecs.INT.decode((Object)buf);
            return new WoodenCrucibleRecipe(ingredient, fluidId, amount);
        }

        private static void encode(RegistryFriendlyByteBuf buf, WoodenCrucibleRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getIngredient());
            ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)recipe.getFluidId());
            ByteBufCodecs.INT.encode((Object)buf, (Object)recipe.getAmount());
        }
    }
}

