/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import java.util.function.Consumer;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.common.CommonCapabilities;
import net.blay09.mods.excompressum.block.IUglyfiable;
import net.blay09.mods.excompressum.block.ModBlockStateProperties;
import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.registry.autosieveskin.AutoSieveSkinRegistry;
import net.blay09.mods.excompressum.registry.autosieveskin.WhitelistEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AutoSieveBaseBlock
extends BaseEntityBlock
implements IUglyfiable {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty UGLY = ModBlockStateProperties.UGLY;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private ItemStack lastHoverStack = ItemStack.EMPTY;
    private String currentRandomName;

    protected AutoSieveBaseBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UGLY, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, UGLY, WATERLOGGED});
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (itemStack.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AbstractAutoSieveBlockEntity)) {
            return InteractionResult.FAIL;
        }
        AbstractAutoSieveBlockEntity autoSieve = (AbstractAutoSieveBlockEntity)blockEntity;
        Item heldItem = itemStack.getItem();
        if (itemStack.has(DataComponents.FOOD) && ExCompressumConfig.getActive().automation.allowAutoSieveFoodSpeedBoosts) {
            FoodProperties food = (FoodProperties)itemStack.get(DataComponents.FOOD);
            if (autoSieve.getFoodBoost() <= 1.0f && food != null) {
                autoSieve.applyFoodBoost(food);
                int countBefore = itemStack.getCount();
                itemStack.consume(1, (LivingEntity)player);
                UseRemainder remainder = (UseRemainder)itemStack.get(DataComponents.USE_REMAINDER);
                if (remainder != null) {
                    ItemStack remainderStack = remainder.convertIntoRemainder(itemStack, countBefore, player.hasInfiniteMaterials(), arg_0 -> ((Player)player).handleExtraItemsCreatedOnUse(arg_0));
                    player.setItemInHand(hand, remainderStack);
                }
                level.levelEvent(2005, pos, 0);
            }
            return InteractionResult.SUCCESS;
        }
        if (heldItem == Items.NAME_TAG && itemStack.has(DataComponents.CUSTOM_NAME)) {
            autoSieve.setSkinProfile(ResolvableProfile.createUnresolved((String)((Component)itemStack.get(DataComponents.CUSTOM_NAME)).getString()));
            return InteractionResult.CONSUME;
        }
        return super.useItemOn(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity;
        if (!player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            Balm.getNetworking().openMenu(player, menuProvider);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, blockHitResult);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        Container container;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null && (container = (Container)Balm.getCapabilities().getCapability(blockEntity, CommonCapabilities.CONTAINER)) != null) {
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)container);
        }
        return 0;
    }

    protected Component getSkinTooltip(String name) {
        return Component.translatable((String)"tooltip.excompressum.auto_sieve", (Object[])new Object[]{name}).withStyle(ChatFormatting.GRAY);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        ResolvableProfile profile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        if (profile != null) {
            tooltip.accept(this.getSkinTooltip(profile.partialProfile().name()));
        } else {
            if (this.currentRandomName == null) {
                this.updateRandomSkinName();
            }
            tooltip.accept(this.getSkinTooltip(this.currentRandomName));
        }
        if (this.lastHoverStack != stack) {
            this.updateRandomSkinName();
            this.lastHoverStack = stack;
        }
    }

    private void updateRandomSkinName() {
        WhitelistEntry randomSkin = AutoSieveSkinRegistry.getRandomSkin();
        this.currentRandomName = randomSkin != null ? randomSkin.getName() : "Steve";
    }

    @Override
    public boolean uglify(@Nullable Player player, Level level, BlockPos pos, BlockState state, InteractionHand hand, Direction facing, Vec3 hitVec) {
        if (!((Boolean)state.getValue((Property)UGLY)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)UGLY, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos facingPos, BlockState facingState, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, facingPos, facingState, randomSource);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.animateTick(state, level, pos, rand);
        if (!((Boolean)state.getValue((Property)UGLY)).booleanValue() && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            float posX = (float)pos.getX() + 0.5f;
            float posY = (float)((double)((float)pos.getY() + 0.6f) + Math.random() * 0.25);
            float posZ = (float)pos.getZ() + 0.5f;
            float speed = 0.25f;
            float motionX = 0.0f * speed;
            float motionY = (float)((0.5 + Math.random() - 0.5) * (double)speed);
            float motionZ = 0.0f * speed;
            level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, (double)posX, (double)posY, (double)posZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    public abstract BlockEntityType<?> getBlockEntityType();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? AutoSieveBaseBlock.createTickerHelper(type, this.getBlockEntityType(), AbstractAutoSieveBlockEntity::clientTick) : AutoSieveBaseBlock.createTickerHelper(type, this.getBlockEntityType(), AbstractAutoSieveBlockEntity::serverTick);
    }
}

