/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.blay09.mods.excompressum.block.entity.BaitBlockStateCondition;
import net.blay09.mods.excompressum.block.entity.BaitBlockTagCondition;
import net.blay09.mods.excompressum.block.entity.BaitEnvironmentCondition;
import net.blay09.mods.excompressum.block.entity.BaitFluidCondition;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public enum BaitType implements StringRepresentable
{
    WOLF(new ItemStack((ItemLike)Items.BEEF), new ItemStack((ItemLike)Items.BONE), EntityType.WOLF, () -> ExCompressumConfig.getActive().baits.wolfBaitChance, 0xD7D3D3, 13545366),
    OCELOT(new ItemStack((ItemLike)Items.GUNPOWDER), new ItemStack((ItemLike)Items.COD), EntityType.OCELOT, () -> ExCompressumConfig.getActive().baits.ocelotBaitChance, 15720061, 5653556),
    COW(new ItemStack((ItemLike)Items.WHEAT), new ItemStack((ItemLike)Items.WHEAT), EntityType.COW, () -> ExCompressumConfig.getActive().baits.cowBaitChance, 4470310, 0xA1A1A1),
    PIG(new ItemStack((ItemLike)Items.CARROT), new ItemStack((ItemLike)Items.CARROT), EntityType.PIG, () -> ExCompressumConfig.getActive().baits.pigBaitChance, 15771042, 14377823),
    CHICKEN(new ItemStack((ItemLike)Items.WHEAT_SEEDS), new ItemStack((ItemLike)Items.WHEAT_SEEDS), EntityType.CHICKEN, () -> ExCompressumConfig.getActive().baits.chickenBaitChance, 0xA1A1A1, 0xFF0000),
    SHEEP(new ItemStack((ItemLike)Items.WHEAT_SEEDS), new ItemStack((ItemLike)Items.WHEAT), EntityType.SHEEP, () -> ExCompressumConfig.getActive().baits.sheepBaitChance, 0xE7E7E7, 0xFFB5B5),
    SQUID(new ItemStack((ItemLike)Items.COD), new ItemStack((ItemLike)Items.COD), EntityType.SQUID, () -> ExCompressumConfig.getActive().baits.squidBaitChance, 2243405, 7375001),
    RABBIT(new ItemStack((ItemLike)Items.CARROT), new ItemStack((ItemLike)Items.MELON_SEEDS), EntityType.RABBIT, () -> ExCompressumConfig.getActive().baits.rabbitBaitChance, 10051392, 7555121),
    HORSE(new ItemStack((ItemLike)Items.GOLDEN_APPLE), new ItemStack((ItemLike)Items.GOLDEN_APPLE), EntityType.HORSE, () -> ExCompressumConfig.getActive().baits.horseBaitChance, 6842447, 15066584),
    DONKEY(new ItemStack((ItemLike)Items.GOLDEN_CARROT), new ItemStack((ItemLike)Items.GOLDEN_CARROT), EntityType.DONKEY, () -> ExCompressumConfig.getActive().baits.donkeyBaitChance, 5457209, 8811878),
    POLAR_BEAR(new ItemStack((ItemLike)Items.SNOWBALL), new ItemStack((ItemLike)Items.COD), EntityType.POLAR_BEAR, () -> ExCompressumConfig.getActive().baits.polarBearBaitChance, 0xF2F2F2, 0x959590),
    LLAMA(new ItemStack((ItemLike)Items.WHEAT), new ItemStack((ItemLike)Items.SUGAR), EntityType.LLAMA, () -> ExCompressumConfig.getActive().baits.llamaBaitChance, 15377456, 4547222),
    PARROT(new ItemStack((ItemLike)Items.RED_DYE), new ItemStack((ItemLike)Items.GREEN_DYE), EntityType.PARROT, () -> ExCompressumConfig.getActive().baits.parrotBaitChance, 894731, 0xFF0000),
    CAT(new ItemStack((ItemLike)Items.LEAD), new ItemStack((ItemLike)Items.COD), EntityType.CAT, () -> ExCompressumConfig.getActive().baits.catBaitChance, 15714446, 9794134),
    FOX(new ItemStack((ItemLike)Items.RABBIT), new ItemStack((ItemLike)Items.SWEET_BERRIES), EntityType.FOX, () -> ExCompressumConfig.getActive().baits.foxBaitChance, 14005919, 13396256),
    TURTLE(new ItemStack((ItemLike)Items.SEAGRASS), new ItemStack((ItemLike)Items.SEA_PICKLE), EntityType.TURTLE, () -> ExCompressumConfig.getActive().baits.turtleBaitChance, 0xE7E7E7, 44975),
    MOOSHROOM(new ItemStack((ItemLike)Items.RED_MUSHROOM), new ItemStack((ItemLike)Items.WHEAT), EntityType.MOOSHROOM, () -> ExCompressumConfig.getActive().baits.mooshroomBaitChance, 10489616, 0xB7B7B7);

    public static final StringRepresentable.EnumCodec<BaitType> CODEC;
    private final ItemStack displayItemFirst;
    private final ItemStack displayItemSecond;
    private final EntityType<?> entityType;
    private final Supplier<Double> chanceSupplier;
    private final int primaryColor;
    private final int secondaryColor;
    private List<BaitEnvironmentCondition> environmentConditions;

    private BaitType(ItemStack displayItemFirst, ItemStack displayItemSecond, EntityType<?> entityType, Supplier<Double> chanceSupplier, int primaryColor, int secondaryColor) {
        this.displayItemFirst = displayItemFirst;
        this.displayItemSecond = displayItemSecond;
        this.entityType = entityType;
        this.chanceSupplier = chanceSupplier;
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Nullable
    public Entity createEntity(Level level) {
        return this.entityType.create(level, EntitySpawnReason.NATURAL);
    }

    public ItemStack getDisplayItemFirst() {
        return this.displayItemFirst;
    }

    public ItemStack getDisplayItemSecond() {
        return this.displayItemSecond;
    }

    public float getChance() {
        return this.chanceSupplier.get().floatValue();
    }

    public Collection<BaitEnvironmentCondition> getEnvironmentConditions() {
        if (this.environmentConditions == null) {
            this.environmentConditions = this == OCELOT || this == PARROT ? Lists.newArrayList((Object[])new BaitEnvironmentCondition[]{new BaitBlockTagCondition((TagKey<Block>)BlockTags.LOGS, (Component)Component.translatable((String)"tooltip.excompressum.bait.logs")), new BaitBlockStateCondition(Blocks.VINE.defaultBlockState()), new BaitBlockStateCondition(Blocks.LILY_PAD.defaultBlockState()), new BaitBlockTagCondition((TagKey<Block>)BlockTags.SAPLINGS, (Component)Component.translatable((String)"tooltip.excompressum.bait.saplings"))}) : (this == SQUID ? Lists.newArrayList((Object[])new BaitEnvironmentCondition[]{new BaitFluidCondition((Fluid)Fluids.WATER), new BaitFluidCondition((Fluid)Fluids.FLOWING_WATER)}) : (this == POLAR_BEAR ? Lists.newArrayList((Object[])new BaitEnvironmentCondition[]{new BaitFluidCondition((Fluid)Fluids.WATER), new BaitBlockStateCondition(Blocks.SNOW.defaultBlockState()), new BaitBlockStateCondition(Blocks.SNOW_BLOCK.defaultBlockState())}) : Lists.newArrayList((Object[])new BaitEnvironmentCondition[]{new BaitBlockStateCondition(Blocks.GRASS_BLOCK.defaultBlockState()), new BaitBlockStateCondition(Blocks.TALL_GRASS.defaultBlockState()), new BaitBlockStateCondition(Blocks.FERN.defaultBlockState()), new BaitBlockStateCondition(Blocks.LARGE_FERN.defaultBlockState()), new BaitBlockTagCondition((TagKey<Block>)BlockTags.LOGS, (Component)Component.translatable((String)"tooltip.excompressum.bait.logs")), new BaitBlockTagCondition((TagKey<Block>)BlockTags.SAPLINGS, (Component)Component.translatable((String)"tooltip.excompressum.bait.saplings"))})));
        }
        return this.environmentConditions;
    }

    public int getItemColor(int tintIndex) {
        return tintIndex == 0 ? this.primaryColor : this.secondaryColor;
    }

    static {
        CODEC = StringRepresentable.fromEnum(BaitType::values);
    }
}

