/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.excompressum.block.WoodenCrucibleType;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.block.entity.WoodenCrucibleBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WoodenCrucibleBlock
extends BaseEntityBlock {
    public static final MapCodec<WoodenCrucibleBlock> CODEC = RecordCodecBuilder.mapCodec(it -> it.group((App)WoodenCrucibleType.CODEC.fieldOf("type").forGetter(WoodenCrucibleBlock::getType), (App)WoodenCrucibleBlock.propertiesCodec()).apply((Applicative)it, WoodenCrucibleBlock::new));
    private static final VoxelShape BOUNDING_BOX = Shapes.or((VoxelShape)Shapes.box((double)0.0, (double)0.1875, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.0625, (double)0.125, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375), Shapes.box((double)0.125, (double)0.0625, (double)0.125, (double)0.875, (double)0.125, (double)0.875), Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.0625, (double)0.1875, (double)0.0625), Shapes.box((double)0.9375, (double)0.0, (double)0.0, (double)1.0, (double)0.1875, (double)0.0625), Shapes.box((double)0.0, (double)0.0, (double)0.9375, (double)0.0625, (double)0.1875, (double)1.0), Shapes.box((double)0.9375, (double)0.0, (double)0.9375, (double)1.0, (double)0.1875, (double)1.0)});
    private final WoodenCrucibleType type;

    public WoodenCrucibleBlock(WoodenCrucibleType type, BlockBehaviour.Properties properties) {
        super(properties.strength(2.0f));
        this.type = type;
    }

    public WoodenCrucibleType getType() {
        return this.type;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WoodenCrucibleBlockEntity(pos, state);
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        ServerLevel serverLevel;
        if (itemStack.isEmpty()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof WoodenCrucibleBlockEntity)) {
            return InteractionResult.FAIL;
        }
        WoodenCrucibleBlockEntity woodenCrucible = (WoodenCrucibleBlockEntity)blockEntity;
        ItemStack outputStack = ContainerUtils.extractItem((Container)woodenCrucible, (int)0, (int)64, (boolean)false);
        if (!outputStack.isEmpty()) {
            if (!player.getInventory().add(outputStack)) {
                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, outputStack));
            }
            return InteractionResult.PASS;
        }
        if (level instanceof ServerLevel && woodenCrucible.addItem(serverLevel = (ServerLevel)level, itemStack, false, false)) {
            return InteractionResult.CONSUME;
        }
        Balm.getHooks().useFluidTank(state, level, pos, player, hand, blockHitResult);
        return super.useItemOn(itemStack, state, level, pos, player, hand, blockHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof WoodenCrucibleBlockEntity)) {
            return InteractionResult.FAIL;
        }
        WoodenCrucibleBlockEntity woodenCrucible = (WoodenCrucibleBlockEntity)blockEntity;
        ItemStack outputStack = ContainerUtils.extractItem((Container)woodenCrucible, (int)0, (int)64, (boolean)false);
        if (!outputStack.isEmpty()) {
            if (!player.getInventory().add(outputStack)) {
                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, outputStack));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, blockHitResult);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return BOUNDING_BOX;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide() ? WoodenCrucibleBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.woodenCrucible.get()), WoodenCrucibleBlockEntity::serverTick) : null;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

