/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.DefaultEnergyStorage;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.excompressum.block.entity.AbstractAutoSieveBlockEntity;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.component.ModComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class AutoSieveBlockEntity
extends AbstractAutoSieveBlockEntity
implements BalmEnergyStorageProvider {
    private final DefaultEnergyStorage energyStorage = new DefaultEnergyStorage(this, 32000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                this.setChanged();
            }
            return super.fill(maxReceive, simulate);
        }
    };

    public AutoSieveBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public AutoSieveBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.autoSieve.get(), pos, state);
    }

    @Override
    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.child("EnergyStorage").ifPresent(it -> this.energyStorage.deserialize(it));
    }

    @Override
    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.energyStorage.serialize(output.child("EnergyStorage"));
    }

    @Override
    public int getEnergyStored() {
        return this.energyStorage.getEnergy();
    }

    @Override
    public void setEnergyStored(int energy) {
        this.energyStorage.setEnergy(energy);
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public int drainEnergy(int maxExtract, boolean simulate) {
        if (!simulate) {
            this.isDirty = true;
        }
        return this.energyStorage.drain(maxExtract, simulate);
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)ModComponents.energy.get(), (Object)this.energyStorage.getEnergy());
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter input) {
        super.applyImplicitComponents(input);
        Integer energyComponent = (Integer)input.get((DataComponentType)ModComponents.energy.get());
        if (energyComponent != null) {
            this.energyStorage.setEnergy(energyComponent.intValue());
        }
    }
}

