/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.Collection;
import java.util.stream.Collectors;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.excompressum.block.BaitBlock;
import net.blay09.mods.excompressum.block.BaitType;
import net.blay09.mods.excompressum.block.entity.BaitEnvironmentCondition;
import net.blay09.mods.excompressum.block.entity.EnvironmentalConditionResult;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.mixin.LlamaAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;

public class BaitBlockEntity
extends BalmBlockEntity {
    private static final int ENVIRONMENTAL_CHECK_INTERVAL = 200;
    private static final int MAX_BAITS_IN_AREA = 2;
    private static final int MIN_ENV_IN_AREA = 10;
    private static final int MAX_ANIMALS_IN_AREA = 2;
    private static final int SPAWN_CHECK_INTERVAL = 20;
    private static final int MIN_DISTANCE_NO_PLAYERS = 6;
    private EnvironmentalConditionResult environmentStatus;
    private int ticksSinceEnvironmentalCheck;
    private int ticksSinceSpawnCheck;

    public BaitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.bait.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BaitBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void serverTick() {
        BaitType baitType = this.getBaitType();
        ++this.ticksSinceEnvironmentalCheck;
        ++this.ticksSinceSpawnCheck;
        if (this.ticksSinceSpawnCheck >= 20) {
            if (!this.level.isClientSide() && this.level.random.nextFloat() <= baitType.getChance() && this.checkSpawnConditions(true) == EnvironmentalConditionResult.CanSpawn) {
                float range = 6.0f;
                if (this.level.getEntitiesOfClass(Player.class, new AABB((double)((float)this.worldPosition.getX() - 6.0f), (double)((float)this.worldPosition.getY() - 6.0f), (double)((float)this.worldPosition.getZ() - 6.0f), (double)((float)this.worldPosition.getX() + 6.0f), (double)((float)this.worldPosition.getY() + 6.0f), (double)((float)this.worldPosition.getZ() + 6.0f))).isEmpty()) {
                    Entity entity = baitType.createEntity(this.level);
                    if (entity instanceof AgeableMob) {
                        AgeableMob mob = (AgeableMob)entity;
                        if ((double)this.level.random.nextFloat() <= ExCompressumConfig.getActive().baits.childBaitChance) {
                            mob.setAge(-24000);
                        }
                    }
                    if (entity instanceof Turtle) {
                        Turtle turtle = (Turtle)entity;
                        turtle.setHomePos(this.worldPosition);
                    }
                    if (entity instanceof Llama) {
                        Llama llama = (Llama)entity;
                        Llama.Variant[] candidates = Llama.Variant.values();
                        ((LlamaAccessor)llama).callSetVariant(candidates[this.level.random.nextInt(candidates.length)]);
                    }
                    entity.setPos((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5);
                    this.level.addFreshEntity(entity);
                    ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    this.level.playSound(null, this.worldPosition, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.level.removeBlock(this.worldPosition, false);
                }
            }
            this.ticksSinceSpawnCheck = 0;
        }
    }

    public EnvironmentalConditionResult checkSpawnConditions(boolean checkNow) {
        if (checkNow || this.ticksSinceEnvironmentalCheck > 200) {
            BaitType baitType = this.getBaitType();
            Collection<BaitEnvironmentCondition> envBlocks = baitType.getEnvironmentConditions();
            int range = 5;
            int rangeVertical = 3;
            int countBait = 0;
            int countEnvBlocks = 0;
            boolean foundWater = false;
            for (int x = this.worldPosition.getX() - 5; x < this.worldPosition.getX() + 5; ++x) {
                for (int y = this.worldPosition.getY() - 3; y < this.worldPosition.getY() + 3; ++y) {
                    for (int z = this.worldPosition.getZ() - 5; z < this.worldPosition.getZ() + 5; ++z) {
                        BlockPos testPos = new BlockPos(x, y, z);
                        BlockState blockState = this.level.getBlockState(testPos);
                        FluidState fluidState = this.level.getFluidState(testPos);
                        if (blockState.getBlock() instanceof BaitBlock) {
                            ++countBait;
                        } else if (fluidState.getType() == Fluids.WATER || fluidState.getType() == Fluids.FLOWING_WATER) {
                            foundWater = true;
                        }
                        for (BaitEnvironmentCondition envBlock : envBlocks) {
                            if (!envBlock.test(blockState, fluidState)) continue;
                            ++countEnvBlocks;
                        }
                    }
                }
            }
            if (!foundWater) {
                this.environmentStatus = EnvironmentalConditionResult.NoWater;
            } else if (countBait > 2) {
                this.environmentStatus = EnvironmentalConditionResult.NearbyBait;
            } else if (countEnvBlocks < 10) {
                String listOfBlocks = envBlocks.stream().map(BaitEnvironmentCondition::getDisplayName).map(Component::getString).collect(Collectors.joining(", "));
                this.environmentStatus = EnvironmentalConditionResult.wrongEnv(listOfBlocks);
            } else {
                this.environmentStatus = this.level.getEntitiesOfClass(Animal.class, new AABB((double)(this.worldPosition.getX() - 10), (double)(this.worldPosition.getY() - 3), (double)(this.worldPosition.getZ() - 10), (double)(this.worldPosition.getX() + 10), (double)(this.worldPosition.getY() + 3), (double)(this.worldPosition.getZ() + 10))).size() > 2 ? EnvironmentalConditionResult.NearbyAnimal : EnvironmentalConditionResult.CanSpawn;
            }
            this.ticksSinceEnvironmentalCheck = 0;
        }
        return this.environmentStatus;
    }

    public BaitType getBaitType() {
        return ((BaitBlock)this.getBlockState().getBlock()).getBaitType();
    }
}

