/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block.entity;

import java.util.List;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.entity.ModBlockEntities;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.ExRegistries;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.Nullable;

public class HeavySieveBlockEntity
extends BalmBlockEntity {
    private static final float PROCESSING_INTERVAL = 0.075f;
    private static final int UPDATE_INTERVAL = 5;
    private static final int PARTICLE_TICKS = 20;
    private static final float EFFICIENCY_BOOST = 0.25f;
    private ItemStack meshStack = ItemStack.EMPTY;
    private ItemStack currentStack = ItemStack.EMPTY;
    private float progress;
    private int clicksSinceSecond;
    private boolean isDirty;
    private int ticksSinceSync;
    private int ticksSinceSecond;
    private int particleTicks;
    private int particleCount;

    public HeavySieveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.heavySieve.get(), pos, state);
    }

    public boolean addSiftable(ServerLevel level, Player player, ItemStack itemStack) {
        if (!this.currentStack.isEmpty() || this.meshStack.isEmpty() || !ExRegistries.getHeavySieveRegistry().isSiftable(level, this.getBlockState(), itemStack, this.getSieveMesh())) {
            return false;
        }
        this.currentStack = player.getAbilities().instabuild ? ContainerUtils.copyStackWithSize((ItemStack)itemStack, (int)1) : itemStack.split(1);
        this.progress = 0.0f;
        this.sync();
        return true;
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, HeavySieveBlockEntity blockEntity) {
        blockEntity.clientTick();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, HeavySieveBlockEntity blockEntity) {
        blockEntity.serverTick();
    }

    public void clientTick() {
        if (this.particleTicks > 0) {
            BlockState state;
            --this.particleTicks;
            if (this.particleTicks <= 0) {
                this.particleCount = 0;
            }
            if (!this.currentStack.isEmpty() && !(state = StupidUtils.getStateFromItemStack(this.currentStack)).isAir()) {
                ExCompressum.proxy.get().spawnHeavySieveParticles(this.level, this.worldPosition, state, this.particleCount);
            }
        }
    }

    public void serverTick() {
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 5) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
        ++this.ticksSinceSecond;
        if (this.ticksSinceSecond >= 20) {
            this.clicksSinceSecond = 0;
            this.ticksSinceSecond = 0;
        }
    }

    public boolean processContents(Player player) {
        if (this.currentStack.isEmpty() || this.meshStack.isEmpty()) {
            return false;
        }
        if (player.getAbilities().instabuild) {
            this.progress = 1.0f;
        } else {
            ++this.clicksSinceSecond;
            if (this.clicksSinceSecond <= ExCompressumConfig.getActive().automation.heavySieveClicksPerSecond) {
                int efficiency = ExNihilo.getInstance().getMeshEfficiency(this.meshStack);
                this.progress = Math.min(1.0f, this.progress + 0.075f * (1.0f + (float)efficiency * 0.25f));
            }
        }
        if (this.progress >= 1.0f) {
            this.particleCount = 0;
            if (!this.level.isClientSide()) {
                SieveMeshRegistryEntry sieveMesh = this.getSieveMesh();
                if (sieveMesh != null) {
                    LootContext lootContext = LootTableUtils.buildLootContext((ServerLevel)this.level, this.currentStack);
                    List<ItemStack> rewards = HeavySieveRegistry.rollSieveRewards(this.level, lootContext, this.getBlockState(), sieveMesh, this.currentStack);
                    for (ItemStack itemStack : rewards) {
                        this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5, itemStack));
                    }
                } else {
                    this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5, this.currentStack));
                }
                this.currentStack = ItemStack.EMPTY;
                if (ExNihilo.getInstance().doMeshesHaveDurability() && sieveMesh != null) {
                    if (!sieveMesh.isHeavy()) {
                        this.level.playSound(null, this.worldPosition, (SoundEvent)SoundEvents.ITEM_BREAK.value(), SoundSource.BLOCKS, 0.5f, 2.5f);
                        this.meshStack = ItemStack.EMPTY;
                    } else {
                        this.meshStack.hurtAndBreak(1, (ServerLevel)this.level, (ServerPlayer)player, it -> {
                            this.level.playSound(null, this.worldPosition, (SoundEvent)SoundEvents.ITEM_BREAK.value(), SoundSource.BLOCKS, 0.5f, 2.5f);
                            this.meshStack = ItemStack.EMPTY;
                        });
                    }
                }
                this.progress = 0.0f;
                this.sync();
            }
        }
        this.setChanged();
        this.particleTicks = 20;
        ++this.particleCount;
        this.isDirty = true;
        return true;
    }

    public void loadAdditional(ValueInput input) {
        this.currentStack = input.read("Content", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
        this.meshStack = input.read("Mesh", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
        this.progress = input.getFloatOr("Progress", 0.0f);
        this.particleTicks = input.getIntOr("ParticleTicks", 0);
        this.particleCount = input.getIntOr("ParticleCount", 0);
    }

    public void saveAdditional(ValueOutput output) {
        output.store("Content", ItemStack.OPTIONAL_CODEC, (Object)this.currentStack);
        output.store("Mesh", ItemStack.OPTIONAL_CODEC, (Object)this.meshStack);
        output.putFloat("Progress", this.progress);
        output.putInt("ParticleTicks", this.particleTicks);
        output.putInt("ParticleCount", this.particleCount);
    }

    public void writeUpdateTag(ValueOutput output) {
        this.saveAdditional(output);
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public ItemStack getMeshStack() {
        return this.meshStack;
    }

    public float getProgress() {
        return this.progress;
    }

    @Nullable
    public SieveMeshRegistryEntry getSieveMesh() {
        if (!this.meshStack.isEmpty()) {
            return SieveMeshRegistry.getEntry(this.meshStack);
        }
        return null;
    }

    public void setMeshStack(ItemStack meshStack) {
        this.meshStack = meshStack;
        this.setChanged();
        this.sync();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        if (this.level != null && !this.getMeshStack().isEmpty()) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, this.getMeshStack()));
        }
    }
}

