/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.excompressum.block.entity.WoodenCrucibleBlockEntity;
import net.blay09.mods.excompressum.client.ModModels;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WoodenCrucibleRenderer
implements BlockEntityRenderer<WoodenCrucibleBlockEntity, WoodenCrucibleRenderState> {
    private final ItemModelResolver itemModelResolver;

    public WoodenCrucibleRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public void extractRenderState(WoodenCrucibleBlockEntity blockEntity, WoodenCrucibleRenderState renderState, float delta, Vec3 vec, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, delta, vec, crumblingOverlay);
        Level level = blockEntity.getLevel();
        this.itemModelResolver.updateForTopItem(renderState.item, blockEntity.getItem(0), ItemDisplayContext.FIXED, level, null, 0);
        renderState.fluidLevel = (float)blockEntity.getFluidTank().getAmount() / (float)blockEntity.getFluidTank().getCapacity();
        renderState.waterColor = level != null ? ((Biome)level.getBiome(blockEntity.getBlockPos()).value()).getWaterColor() : -1;
        renderState.solidLevel = (float)blockEntity.getSolidVolume() / (float)blockEntity.getSolidCapacity();
    }

    public WoodenCrucibleRenderState createRenderState() {
        return new WoodenCrucibleRenderState();
    }

    public void submit(WoodenCrucibleRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!renderState.item.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.0625f, 0.2f, 0.0625f);
            poseStack.scale(0.875f, 0.75f, 0.875f);
            renderState.item.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        if (renderState.fluidLevel > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0f, renderState.fluidLevel * 11.0f / 16.0f, 0.0f);
            int color = renderState.waterColor;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            BlockStateModel model = (BlockStateModel)ModModels.woodenCrucibleLiquid.get();
            submitNodeCollector.submitBlockModel(poseStack, RenderType.translucentMovingBlock(), model, red, green, blue, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
        if (renderState.solidLevel > 0.0f) {
            poseStack.pushPose();
            poseStack.translate(0.0625f, 0.251f, 0.0625f);
            poseStack.scale(0.875f, 0.71f * renderState.solidLevel, 0.875f);
            BlockState solidState = Blocks.DARK_OAK_LEAVES.defaultBlockState();
            submitNodeCollector.submitBlock(poseStack, solidState, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    public static class WoodenCrucibleRenderState
    extends BlockEntityRenderState {
        public final ItemStackRenderState item = new ItemStackRenderState();
        public int waterColor;
        public float fluidLevel;
        public float solidLevel;
    }
}

