/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.blay09.mods.excompressum.entity.AngryChickenEntity;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.ChickenRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class AngryChickenRenderer
extends MobRenderer<AngryChickenEntity, ChickenRenderState, ChickenModel> {
    private static final ResourceLocation chickenTextures = ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"textures/entity/angry_chicken.png");

    public AngryChickenRenderer(EntityRendererProvider.Context context, ChickenModel model, float shadowSize) {
        super(context, (EntityModel)model, shadowSize);
    }

    public ResourceLocation getTextureLocation(ChickenRenderState entity) {
        return chickenTextures;
    }

    public void submit(ChickenRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        float scale = renderState.scale;
        poseStack.scale(scale, scale, scale);
        super.submit((LivingEntityRenderState)renderState, poseStack, submitNodeCollector, cameraRenderState);
        poseStack.popPose();
    }

    public void extractRenderState(AngryChickenEntity angryChicken, ChickenRenderState renderState, float delta) {
        super.extractRenderState((LivingEntity)angryChicken, (LivingEntityRenderState)renderState, delta);
        renderState.scale = angryChicken.getAngryScale();
    }

    public ChickenRenderState createRenderState() {
        return new ChickenRenderState();
    }
}

