/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.blay09.mods.excompressum.api.recipe.CompressedHammerRecipe;
import net.blay09.mods.excompressum.api.recipe.HammerRecipe;
import net.blay09.mods.excompressum.api.recipe.SieveRecipe;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.block.HeavySieveBlock;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.compat.jei.ChickenStickJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.CompressedHammerJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.CraftChickenStickJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.CraftChickenStickRecipe;
import net.blay09.mods.excompressum.compat.jei.HammerJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.HeavySieveJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.SieveJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.jei.WoodenCrucibleJeiRecipeCategory;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedCompressedHammerRecipe;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedHammerRecipe;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedHeavySieveRecipe;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedSieveRecipe;
import net.blay09.mods.excompressum.compat.recipeviewers.ExpandedWoodenCrucibleRecipe;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.registry.ExNihilo;
import net.blay09.mods.excompressum.registry.heavysieve.GeneratedHeavySieveRecipe;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRecipeImpl;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRecipe;
import net.blay09.mods.excompressum.tag.ModItemTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;

@JeiPlugin
public class JEIAddon
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration registry) {
        ArrayList expandedHeavySieveRecipes = new ArrayList();
        ClientLevel level = Minecraft.getInstance().level;
        registry.addRecipes(HeavySieveJeiRecipeCategory.TYPE, expandedHeavySieveRecipes);
        ArrayList<ExpandedSieveRecipe> expandedSieveRecipes = new ArrayList<ExpandedSieveRecipe>();
        for (SieveRecipe sieveRecipe : ExNihilo.getInstance().getSieveRecipes()) {
            expandedSieveRecipes.add(new ExpandedSieveRecipe(null, sieveRecipe));
        }
        registry.addRecipes(SieveJeiRecipeCategory.TYPE, expandedSieveRecipes);
        ArrayList<ExpandedCompressedHammerRecipe> expandedCompressedHammerRecipes = new ArrayList<ExpandedCompressedHammerRecipe>();
        for (CompressedHammerRecipe compressedHammerRecipe : ExNihilo.getInstance().getCompressedHammerRecipes()) {
            expandedCompressedHammerRecipes.add(new ExpandedCompressedHammerRecipe(null, compressedHammerRecipe));
        }
        registry.addRecipes(CompressedHammerJeiRecipeCategory.TYPE, expandedCompressedHammerRecipes);
        ArrayList<ExpandedHammerRecipe> arrayList = new ArrayList<ExpandedHammerRecipe>();
        for (HammerRecipe recipe : ExNihilo.getInstance().getHammerRecipes()) {
            arrayList.add(new ExpandedHammerRecipe(null, recipe));
        }
        registry.addRecipes(HammerJeiRecipeCategory.TYPE, arrayList);
        ArrayList arrayList2 = new ArrayList();
        registry.addRecipes(ChickenStickJeiRecipeCategory.TYPE, arrayList2);
        ArrayListMultimap fluidOutputMap = ArrayListMultimap.create();
        ArrayList<ExpandedWoodenCrucibleRecipe> expandedWoodenCrucibleRecipes = new ArrayList<ExpandedWoodenCrucibleRecipe>();
        for (ResourceLocation fluidName : fluidOutputMap.keySet()) {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.getValue(fluidName);
            if (fluid == null) continue;
            List recipes = fluidOutputMap.get((Object)fluidName);
            ArrayList<Pair> inputs = new ArrayList<Pair>();
            for (WoodenCrucibleRecipe woodenCrucibleRecipe : recipes) {
            }
            inputs.sort(Comparator.comparingInt(pair -> ((WoodenCrucibleRecipe)pair.getFirst()).getAmount()).reversed());
            int pageSize = 45;
            List pages = Lists.partition(inputs, (int)45);
            for (List page : pages) {
                expandedWoodenCrucibleRecipes.add(new ExpandedWoodenCrucibleRecipe(null, fluid, page));
            }
        }
        registry.addRecipes(WoodenCrucibleJeiRecipeCategory.TYPE, expandedWoodenCrucibleRecipes);
        registry.addRecipes(CraftChickenStickJeiRecipeCategory.TYPE, (List)Lists.newArrayList((Object[])new CraftChickenStickRecipe[]{new CraftChickenStickRecipe()}));
    }

    private void loadGeneratedHeavySieveRecipe(Level level, boolean waterlogged, GeneratedHeavySieveRecipe generatedRecipe, List<ExpandedHeavySieveRecipe> outRecipes) {
        BlockState waterLoggedState = (BlockState)ModBlocks.heavySieves[0].defaultBlockState().setValue((Property)HeavySieveBlock.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        for (SieveMeshRegistryEntry mesh : SieveMeshRegistry.getEntries().values()) {
            Integer rolls = HeavySieveRegistry.getGeneratedRollCount(generatedRecipe);
            Item source = (Item)BuiltInRegistries.ITEM.getValue(generatedRecipe.getSourceItem());
            LootTable lootTable = ExNihilo.getInstance().generateHeavySieveLootTable(level, waterLoggedState, (ItemLike)source, rolls, mesh);
            if (LootTableUtils.isLootTableEmpty(lootTable)) continue;
            HeavySieveRecipeImpl recipe = new HeavySieveRecipeImpl(generatedRecipe.getIngredient(), lootTable, waterlogged, List.of(mesh.getMeshType()));
            outRecipes.add(new ExpandedHeavySieveRecipe(null, recipe));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.autoSieve), new RecipeType[]{SieveJeiRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.autoHeavySieve), new RecipeType[]{HeavySieveJeiRecipeCategory.TYPE});
        for (Block heavySieve : ModBlocks.heavySieves) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)heavySieve), new RecipeType[]{HeavySieveJeiRecipeCategory.TYPE});
        }
        for (Block woodenCrucible : ModBlocks.woodenCrucibles) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)woodenCrucible), new RecipeType[]{WoodenCrucibleJeiRecipeCategory.TYPE});
        }
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.chickenStick), new RecipeType[]{ChickenStickJeiRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.autoCompressedHammer), new RecipeType[]{CompressedHammerJeiRecipeCategory.TYPE});
        for (Holder itemHolder : BuiltInRegistries.ITEM.getTagOrEmpty(ModItemTags.COMPRESSED_HAMMERS)) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)itemHolder.value()), new RecipeType[]{CompressedHammerJeiRecipeCategory.TYPE});
        }
        registry.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.autoHammer), new RecipeType[]{HammerJeiRecipeCategory.TYPE});
        for (Holder itemHolder : BuiltInRegistries.ITEM.getTagOrEmpty(ModItemTags.HAMMERS)) {
            registry.addRecipeCatalyst(new ItemStack((ItemLike)itemHolder.value()), new RecipeType[]{HammerJeiRecipeCategory.TYPE});
        }
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"excompressum", (String)"jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SieveJeiRecipeCategory(registry.getJeiHelpers()), new HeavySieveJeiRecipeCategory(registry.getJeiHelpers()), new HammerJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new CompressedHammerJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new WoodenCrucibleJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new CraftChickenStickJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new ChickenStickJeiRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }
}

