/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.recipeviewers;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.blay09.mods.excompressum.api.recipe.SieveRecipe;
import net.blay09.mods.excompressum.api.sievemesh.CommonMeshType;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.loot.LootTableEntry;
import net.blay09.mods.excompressum.loot.LootTableUtils;
import net.blay09.mods.excompressum.loot.MergedLootTableEntry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ExpandedSieveRecipe {
    private final ResourceLocation id;
    private final SieveRecipe recipe;
    private final Ingredient ingredient;
    private final List<ItemStack> meshItems;
    private final List<MergedLootTableEntry> outputs;
    private final List<ItemStack> outputItems;
    private final boolean waterlogged;

    public ExpandedSieveRecipe(ResourceLocation id, SieveRecipe recipe) {
        this.id = id;
        this.recipe = recipe;
        this.meshItems = new ArrayList<ItemStack>();
        for (CommonMeshType meshType : recipe.getMeshes()) {
            for (SieveMeshRegistryEntry mesh : SieveMeshRegistry.getEntries().values()) {
                if (mesh.getMeshType() != meshType) continue;
                this.meshItems.add(mesh.getItemStack());
            }
        }
        this.ingredient = recipe.getIngredient();
        List<LootTableEntry> entries = LootTableUtils.getLootTableEntries(recipe.getLootTable());
        this.outputs = LootTableUtils.mergeLootTableEntries(entries);
        this.outputItems = this.outputs.stream().map(MergedLootTableEntry::getItemStack).collect(Collectors.toList());
        this.waterlogged = recipe.isWaterlogged();
    }

    public SieveRecipe getRecipe() {
        return this.recipe;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<ItemStack> getMeshItems() {
        return this.meshItems;
    }

    public List<MergedLootTableEntry> getOutputs() {
        return this.outputs;
    }

    public List<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    public ResourceLocation getId() {
        return this.id;
    }
}

