/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.reflection.Comment;
import net.blay09.mods.balm.api.config.reflection.Config;
import net.blay09.mods.balm.api.config.reflection.NestedType;

@Config(value="excompressum")
public class ExCompressumConfig {
    public General general = new General();
    public Baits baits = new Baits();
    public CompressedMobs compressedMobs = new CompressedMobs();
    public Tools tools = new Tools();
    public Automation automation = new Automation();
    public Client client = new Client();

    public static void initialize() {
        Balm.getConfig().registerConfig(ExCompressumConfig.class);
    }

    public static ExCompressumConfig getActive() {
        return (ExCompressumConfig)Balm.getConfig().getActiveConfig(ExCompressumConfig.class);
    }

    public static class General {
        @Comment(value="The amount of times the heavy sieve should roll for compressed entries. For example, a value of 7 means for every compressed gravel you only get the equivalent drops of 7 sifted gravel blocks (2 loss). A value of 9 would therefore mean no loss.")
        public int heavySieveDefaultRolls = 7;
    }

    public static class Baits {
        @Comment(value="The chance (per second) that a wolf bait will result in a spawn.")
        public double wolfBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a ocelot bait will result in a spawn.")
        public double ocelotBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a cow bait will result in a spawn.")
        public double cowBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a pig bait will result in a spawn.")
        public double pigBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a chicken bait will result in a spawn.")
        public double chickenBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a sheep bait will result in a spawn.")
        public double sheepBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a squid bait will result in a spawn.")
        public double squidBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a rabbit bait will result in a spawn.")
        public double rabbitBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a mooshroom bait will result in a spawn.")
        public double horseBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a donkey bait will result in a spawn.")
        public double donkeyBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a parrot bait will result in a spawn.")
        public double parrotBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a polar bear bait will result in a spawn.")
        public double polarBearBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a llama bait will result in a spawn.")
        public double llamaBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a cat bait will result in a spawn.")
        public double catBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a fox bait will result in a spawn.")
        public double foxBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a turtle bait will result in a spawn.")
        public double turtleBaitChance = 0.01f;
        @Comment(value="The chance (per second) that a mooshroom bait will result in a spawn.")
        public double mooshroomBaitChance = 0.01f;
        @Comment(value="The chance (per second) that an animal spawned from a bait will result in a child.")
        public double childBaitChance = 0.5;
    }

    public static class CompressedMobs {
        @Comment(value="The chance for mobs to spawn as Compressed Mobs. Set to 0 to disable.")
        public double compressedMobChance = 0.01f;
        @Comment(value="The amount of mobs that will spawn upon death of a compressed mob.")
        public int compressedMobSize = 9;
    }

    public static class Tools {
        @Comment(value="If true, hitting a chicken with a stick will turn it into an Angry Chicken, which will drop a Chicken Stick when killed.")
        public boolean allowChickenStickCreation = true;
        @Comment(value="The chance for the chicken stick to make sounds when breaking blocks. Set to 0 to disable.")
        public double chickenStickSoundChance = 0.2f;
        @Comment(value="The chance for the chicken stick to spawn a chicken. Set to 0 to disable.")
        public double chickenStickSpawnChance = 0.008f;
        @NestedType(value=String.class)
        @Comment(value="The sound names the chicken stick will randomly play.")
        public List<String> chickenStickSounds = Lists.newArrayList((Object[])new String[]{"entity.chicken.ambient", "entity.chicken.hurt", "entity.chicken.egg", "entity.chicken.step"});
        @Comment(value="The multiplier applied to the Compressed Crook's speed (based on the normal wooden crook)")
        public double compressedCrookSpeedMultiplier = 4.0;
    }

    public static class Automation {
        @Comment(value="The energy cost of the auto hammer per tick.")
        public int autoHammerEnergy = 40;
        @Comment(value="The speed at which the auto hammer will smash stuff.")
        public double autoHammerSpeed = 0.008f;
        @Comment(value="The chance for the upgrade hammers in an auto hammer to lose durability (per operation)")
        public double autoHammerDecay = 0.5;
        @Comment(value="The energy cost of the auto compressed hammer per tick.")
        public int autoCompressedHammerEnergy = 120;
        @Comment(value="The speed at which the auto compressed hammer will smash stuff.")
        public double autoCompressedHammerSpeed = 0.0038f;
        @Comment(value="The energy cost of the auto sieve per tick.")
        public int autoSieveEnergy = 40;
        @Comment(value="The energy cost of the auto heavy sieve per tick.")
        public int autoHeavySieveEnergy = 120;
        @Comment(value="The speed at which the auto heavy sieve will sift stuff.")
        public double autoHeavySieveSpeed = 0.00375f;
        @Comment(value="The speed at which the auto sieve will sift stuff.")
        public double autoSieveSpeed = 0.0075f;
        @Comment(value="The energy cost of the auto compressor per tick.")
        public int autoCompressorEnergy = 5;
        @Comment(value="The speed at which the auto compressor will compress stuff.")
        public double autoCompressorSpeed = 0.1f;
        @Comment(value="Set this to true if you want to allow automation of the heavy sieve through fake players (i.e. Autonomous Activator)")
        public boolean allowHeavySieveAutomation = false;
        @Comment(value="The maximum amount of clicks per second on a heavy sieve. Clicks above this will be ignored.")
        public int heavySieveClicksPerSecond = 6;
        @Comment(value="The rate at which the wooden crucible extracts water. Measured in liquid per second.")
        public int woodenCrucibleSpeed = 8;
        @Comment(value="Set this to true if you want to allow right-clicking Auto Sieves with Food to give them speed boosts")
        public boolean allowAutoSieveFoodSpeedBoosts = true;
    }

    public static class Client {
        @Comment(value="Set this to true to disable the loading of auto sieve skins from a remote server.")
        public boolean skipAutoSieveSkins = false;
        @Comment(value="Setting this to true will disable particles from the Sieves and Auto Hammers from Ex Compressum.")
        public boolean disableParticles = false;
    }
}

